/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.db.mongo;

import cn.tom.db.mongo.Annotation;
import cn.tom.db.mongo.MongoDB;
import cn.tom.kit.clazz.ReflectUtil;
import cn.tom.mvc.core.CocookException;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.bson.types.ObjectId;

public class MongoDao {
    public static MongoDB db;
    private static MongoDao self;

    public static void init(File file) {
        db = new MongoDB(file);
    }

    public static void init(Properties pro) {
        db = new MongoDB();
        db.init(pro);
    }

    public static MongoDao getInstance() {
        if (self == null) {
            self = new MongoDao();
        }
        return self;
    }

    public void set_DB(String _db) {
        db.setDb(_db);
    }

    public DBCollection getConllection(String col) {
        return db.getDB().getCollection(col);
    }

    public String insert(String col, Map<String, ? extends Object> data) {
        DBCollection collection = this.getConllection(col);
        BasicDBObject dbObj = new BasicDBObject(data);
        collection.insert((DBObject)dbObj, WriteConcern.SAFE);
        return dbObj.get("_id").toString();
    }

    public String insertAsBean(String col, Object bean) {
        Map<String, Object> map = MongoDao.beanToMap(bean);
        return this.insert(col, map);
    }

    public WriteResult insertAsBeans(String col, List<Object> beans) {
        return this.insert(col, this.toDBList(beans));
    }

    public WriteResult insert(String col, List<DBObject> list) {
        DBCollection collection = this.getConllection(col);
        return collection.insert(list);
    }

    public WriteResult insert(String col, DBObject ... obj) {
        return this.insert(col, Arrays.asList(obj));
    }

    public String save(String col, DBObject obj) {
        DBCollection collection = this.getConllection(col);
        collection.save(obj);
        return obj.get("_id").toString();
    }

    public WriteResult update(String col, DBObject q, DBObject o, boolean upsert, boolean multi) {
        DBCollection collection = this.getConllection(col);
        return collection.update(q, o, upsert, multi);
    }

    public WriteResult update(String col, DBObject q, DBObject o) {
        return this.update(col, q, o, false, false);
    }

    public WriteResult updateSingle(String col, DBObject q, DBObject o) {
        return this.update(col, q, (DBObject)new BasicDBObject("$set", (Object)o), false, false);
    }

    public WriteResult updateMulti(String col, DBObject q, DBObject o) {
        return this.update(col, q, o, false, true);
    }

    public WriteResult updateMultiSingle(String col, DBObject q, DBObject o) {
        return this.update(col, q, (DBObject)new BasicDBObject("$set", (Object)o), false, true);
    }

    public WriteResult updateMulti(String col, Map<String, ? extends Object> q, Map<String, ? extends Object> o) {
        return this.update(col, (DBObject)new BasicDBObject(q), (DBObject)new BasicDBObject("$set", o), false, true);
    }

    public WriteResult updateByidAsBean(String col, String id, Object bean) {
        BasicDBObject _id = new BasicDBObject("_id", (Object)new ObjectId(id));
        Map<String, Object> map = MongoDao.beanToMap(bean);
        if (map.containsKey("_id")) {
            map.remove("_id");
        }
        return this.updateMultiSingle(col, (DBObject)_id, (DBObject)new BasicDBObject(map));
    }

    public WriteResult updateByid(String col, String id, DBObject o) {
        BasicDBObject _id = new BasicDBObject("_id", (Object)new ObjectId(id));
        BasicDBObject ob = (BasicDBObject)o;
        if (ob.containsField("_id")) {
            ob.remove((Object)"_id");
        }
        return this.updateMultiSingle(col, (DBObject)_id, o);
    }

    public WriteResult remove(String col, DBObject o) {
        DBCollection collection = this.getConllection(col);
        return collection.remove(o);
    }

    public WriteResult deleteById(String col, String id) {
        return this.remove(col, (DBObject)new BasicDBObject("_id", (Object)new ObjectId(id)));
    }

    public WriteResult delete(String col, String query) {
        return this.remove(col, (DBObject)JSON.parse((String)query));
    }

    public WriteResult delete(String col, Map<String, ? extends Object> query) {
        return this.remove(col, (DBObject)new BasicDBObject(query));
    }

    public List<?> distinct(String col, String key, DBObject query) {
        DBCollection collection = this.getConllection(col);
        return collection.distinct(key, query);
    }

    public DBObject findOne(String col, DBObject o) {
        DBCollection collection = this.getConllection(col);
        return collection.findOne(o);
    }

    private DBCursor find(String col, DBObject o) {
        DBCollection collection = this.getConllection(col);
        return collection.find(o);
    }

    private DBCursor find(String col, DBObject query, DBObject keys) {
        DBCollection collection = this.getConllection(col);
        return collection.find(query, keys);
    }

    public DBObject findOne(String col, DBObject query, DBObject keys) {
        DBCollection collection = this.getConllection(col);
        List<DBObject> list = this.DBCursor2list(collection.find(query, keys));
        if (list.size() > 0) {
            return list.get(0);
        }
        return new BasicDBObject(0);
    }

    public List<DBObject> DBCursor2list(DBCursor cur) {
        if (cur != null) {
            ArrayList<DBObject> list = new ArrayList<DBObject>();
            while (cur.hasNext()) {
                DBObject dbo = cur.next();
                if (dbo.get("_id") != null) {
                    dbo.put("_id", (Object)dbo.get("_id").toString());
                }
                list.add(dbo);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public List<DBObject> findList(String col, DBObject query) {
        DBCursor cursor = this.find(col, query);
        return this.DBCursor2list(cursor);
    }

    public List<DBObject> findOneList(String col, DBObject query, DBObject key) {
        DBCursor cursor = this.find(col, query, key);
        return this.DBCursor2list(cursor);
    }

    public List<DBObject> findList(String col, DBObject query, DBObject sort) {
        DBCursor cursor = this.find(col, query);
        if (sort != null) {
            cursor.sort(sort);
        }
        return this.DBCursor2list(cursor);
    }

    public List<DBObject> findList(String col, DBObject query, DBObject sort, int start, int limit) {
        DBCursor cursor = this.find(col, query);
        if (sort != null) {
            cursor.sort(sort);
        }
        if (start == 0) {
            cursor.limit(limit);
        } else {
            cursor.skip(start).limit(limit);
        }
        return this.DBCursor2list(cursor);
    }

    public DBObject queryById(String col, String id) {
        BasicDBObject obj = new BasicDBObject();
        obj.put("_id", (Object)new ObjectId(id));
        return this.findOne(col, (DBObject)obj);
    }

    public <T> T getBeanById(String col, String id, Class<T> clazz) {
        BasicDBObject dbObject = (BasicDBObject)this.queryById(col, id);
        if (dbObject == null) {
            return null;
        }
        return MongoDao.mapToBean(dbObject, clazz);
    }

    public <T> T getBean(String col, DBObject query, Class<T> clazz) {
        BasicDBObject dbObject = (BasicDBObject)this.findOne(col, query);
        if (dbObject == null) {
            return null;
        }
        return MongoDao.mapToBean(dbObject, clazz);
    }

    public <T> List<T> getList(String col, DBObject query, Class<T> clazz) {
        List<DBObject> list = this.findList(col, query);
        return this.toBeans(list, clazz);
    }

    public <T> List<T> getList(String col, DBObject query, DBObject sort, Class<T> clazz) {
        List<DBObject> list = this.findList(col, query, sort);
        return this.toBeans(list, clazz);
    }

    public <T> List<T> getList(String col, DBObject query, DBObject sort, int start, int limit, Class<T> clazz) {
        List<DBObject> list = this.findList(col, query, sort, start, limit);
        return this.toBeans(list, clazz);
    }

    public long count(String col, DBObject query) {
        DBCollection collection = this.getConllection(col);
        return collection.count(query);
    }

    public List<DBObject> toDBList(List<Object> beans) {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (Object bean : beans) {
            Map<String, Object> map = MongoDao.beanToMap(bean);
            list.add((DBObject)new BasicDBObject(map));
        }
        return list;
    }

    public <T> List<T> toBeans(List<DBObject> list, Class<T> clazz) {
        ArrayList<T> relist = new ArrayList<T>();
        for (DBObject dbObj : list) {
            BasicDBObject b = (BasicDBObject)dbObj;
            T t = MongoDao.mapToBean(b, clazz);
            relist.add(t);
        }
        return relist;
    }

    public static Map<String, Object> beanToMap(Object bean) {
        PropertyDescriptor[] pros;
        BeanInfo info = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> _class = bean.getClass();
        try {
            info = Introspector.getBeanInfo(_class);
        }
        catch (IntrospectionException e) {
            throw new CocookException(e);
        }
        for (PropertyDescriptor pro : pros = info.getPropertyDescriptors()) {
            String name = pro.getName();
            if ("class".equals(name)) continue;
            Method method = pro.getReadMethod();
            try {
                Annotation.ObjectId objectId = _class.getDeclaredField(name).getAnnotation(Annotation.ObjectId.class);
                Object result = method.invoke(bean, new Object[0]);
                if (objectId != null && result != null) {
                    result = new ObjectId((String)result);
                }
                if (result == null) continue;
                map.put(name, result);
            }
            catch (Exception e) {
                throw new CocookException(e);
            }
        }
        return map;
    }

    public static <T> T mapToBean(Map<String, ?> map, Class<T> _class) {
        T t;
        try {
            t = _class.newInstance();
        }
        catch (Exception e) {
            throw new CocookException(e);
        }
        for (String key : map.keySet()) {
            Object value = map.get(key);
            String methodName = ReflectUtil.toSetMethod(key);
            Method method = ReflectUtil.getDeclaredMethod(_class, methodName);
            ReflectUtil.invokeMethodByConvert(t, method, value);
        }
        return t;
    }
}

