/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.db.jdbc.simple;

import cn.tom.db.jdbc.DBException;
import cn.tom.db.jdbc.DBOperations;
import cn.tom.db.jdbc.Query;
import cn.tom.db.jdbc.simple.DBQuery;
import cn.tom.db.jdbc.simple.DBTemplate;
import cn.tom.kit.clazz.ReflectUtil;
import cn.tom.mvc.jdbc.DBPool;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DBUtil {
    public static final DBOperations TEMPLATE = new DBTemplate();
    private static DBPool dbPool;

    public static void init(File dbFile) {
        dbPool = new DBPool(dbFile);
    }

    public static void init(Properties prop) {
        dbPool = new DBPool();
        dbPool.init(prop);
    }

    public static Connection getConnection() {
        try {
            return dbPool.getConnection();
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static int exec(Connection _conn, String sql, Object ... params) {
        try {
            return TEMPLATE.update(_conn, sql, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static int exec(String sql, Object ... params) {
        try {
            return TEMPLATE.update(sql, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static int exec(Query query) {
        return DBUtil.exec(query.getSql(), query.getParams());
    }

    public static int insert(String sql, Object ... params) {
        try {
            return TEMPLATE.insert(sql, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static int insert(Connection _conn, String sql, Object ... params) {
        try {
            return TEMPLATE.insert(_conn, sql, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static int[] batchUpdate(List<String> sqls) {
        try {
            return TEMPLATE.batchUpdate(sqls);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static int[] batchUpdate(String sql, List<Object[]> list) {
        try {
            return TEMPLATE.batchUpdate(sql, list);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static int[] batchUpdate(String sql, Object ... obj) {
        try {
            return TEMPLATE.batchUpdate(sql, obj);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static int insertDB(String tableName, Object obj) {
        Map<String, Object> map = null;
        map = obj instanceof Map ? (Map<String, Object>)obj : ReflectUtil.beanToMap(obj);
        Query query = DBUtil.getInsertBody(map, tableName);
        return DBUtil.insert(query.getSql(), query.getParams());
    }

    public static int updateDB(String tableName, Object obj, String where) {
        Map<String, Object> map = null;
        map = obj instanceof Map ? (Map<String, Object>)obj : ReflectUtil.beanToMap(obj);
        Query query = DBUtil.getUpdateBody(map, tableName, where);
        return DBUtil.exec(query.getSql(), query.getParams());
    }

    public static Integer getInt(String sql, Object ... params) {
        try {
            Integer i = TEMPLATE.queryForInt(sql, params);
            return i == null ? 0 : i;
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static double getDouble(String sql, Object ... params) {
        try {
            Double i = TEMPLATE.queryForObject(sql, Double.class, params);
            return i == null ? 0.0 : i;
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static Long getLong(String sql, Object ... params) {
        try {
            Long i = TEMPLATE.queryForLong(sql, params);
            return i == null ? 0L : i;
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static String getString(String sql, Object ... params) {
        try {
            return TEMPLATE.queryForString(sql, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static <T> T getObject(String sql, Object ... params) {
        try {
            return TEMPLATE.queryForObject(sql, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static <T> T getObject(String sql, Class<T> clazz, Object ... params) {
        try {
            return TEMPLATE.queryForObject(sql, clazz, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static <T> T getObject(Connection conn, String sql, Class<T> clazz, Object ... params) {
        try {
            return TEMPLATE.queryForObject(conn, sql, clazz, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static <T> List<T> getList(String sql, Class<T> clazz, Object ... params) {
        try {
            return TEMPLATE.queryForList(sql, clazz, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static <T> List<T> getList(Connection conn, String sql, Class<T> clazz, Object ... params) {
        try {
            return TEMPLATE.queryForList(conn, sql, clazz, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static List<Map<String, Object>> getList(Connection conn, String sql, Object ... params) {
        try {
            return TEMPLATE.queryForList(conn, sql, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static List<Map<String, Object>> getList(String sql, Object ... params) {
        try {
            return TEMPLATE.queryForList(sql, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static List<Map<String, Object>> getList(Query query) {
        return DBUtil.getList(query.getSql(), query.getParams());
    }

    public static List<Map<String, Object>> getLinkedMapList(String sql, Object ... params) {
        try {
            return TEMPLATE.queryForLinkedMapList(sql, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static Map<String, Object> getMap(String sql, Object ... params) {
        try {
            return TEMPLATE.queryForMap(sql, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static Map<String, Object> getLinkedMap(String sql, Object ... params) {
        try {
            return TEMPLATE.queryForLinkedMap(sql, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static <T> T getBean(String sql, Class<T> clazz, Object ... params) {
        Map<String, Object> map = DBUtil.getMap(sql, params);
        if (map.isEmpty()) {
            return null;
        }
        return ReflectUtil.mapToBean(map, clazz);
    }

    protected static void bindInputStatement(PreparedStatement statement, int index, Object obj) throws SQLException {
        if (obj instanceof String) {
            statement.setString(index, (String)obj);
        } else if (obj instanceof Integer) {
            statement.setInt(index, (Integer)obj);
        } else if (obj instanceof Date) {
            statement.setTimestamp(index, new Timestamp(((Date)obj).getTime()));
        } else {
            statement.setObject(index, obj);
        }
    }

    public static void bindInputStatement(PreparedStatement statement, Object ... obj) throws SQLException {
        if (obj != null) {
            for (int i = 0; i < obj.length; ++i) {
                DBUtil.bindInputStatement(statement, i + 1, obj[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<Map<String, Object>> getList(ResultSet res, Class<? extends Map> clazz) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            ResultSetMetaData rsmd = res.getMetaData();
            while (res.next()) {
                Map map = clazz.newInstance();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    map.put(rsmd.getColumnLabel(i).toLowerCase(), res.getObject(i));
                }
                list.add(map);
            }
        }
        catch (InstantiationException e) {
            DBPool.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            DBPool.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            DBUtil.close(res);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> List<T> getListT(ResultSet res, Class<T> clazz) throws SQLException {
        ArrayList<T> list = new ArrayList<T>();
        try {
            while (res.next()) {
                Object obj = res.getObject(1);
                list.add(obj == null ? clazz.cast(null) : clazz.cast(ReflectUtil.covert(clazz, obj)));
            }
        }
        finally {
            DBUtil.close(res);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object getObject(ResultSet res) throws SQLException {
        try {
            if (res.next()) {
                Object object = res.getObject(1);
                return object;
            }
        }
        finally {
            DBUtil.close(res);
        }
        return null;
    }

    protected static ResultSet query(Connection _conn, String sql, Object ... params) throws SQLException {
        if (DBPool.show_sql) {
            DBPool.logger.info(sql + " " + Arrays.asList(params));
        }
        PreparedStatement pst = _conn.prepareStatement(sql);
        DBUtil.bindInputStatement(pst, params);
        return pst.executeQuery();
    }

    public static void close(Connection _conn) {
        dbPool.closeConnection(_conn);
    }

    public static void close(ResultSet _rs) {
        if (_rs != null) {
            try {
                _rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(Statement stat) {
        if (stat != null) {
            try {
                stat.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeDataSource() {
        if (dbPool != null) {
            dbPool.closeDataSource();
        }
    }

    private static Query getInsertBody(Map<String, Object> map, String _tableName) {
        DBQuery insert = new DBQuery(new StringBuffer("INSERT INTO " + _tableName + "("));
        String field = "";
        String value = "VALUES( ";
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            if (field.length() > 0) {
                field = field + ", ";
                value = value + ", ";
            }
            field = field + key;
            value = value + "?";
            insert.setParams(obj);
        }
        field = field + ")";
        value = value + ")";
        insert.add(field + value);
        return insert;
    }

    private static Query getUpdateBody(Map<String, Object> _map, String _tableName, String _where) {
        DBQuery update = new DBQuery(new StringBuffer("UPDATE " + _tableName + " SET "));
        String field = "";
        for (String key : _map.keySet()) {
            Object obj = _map.get(key);
            if (field.length() > 0) {
                field = field + ", ";
            }
            field = field + key + " =?";
            update.setParams(obj);
        }
        update.add(field + " WHERE " + _where);
        return update;
    }
}

