/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.db.jdbc.simple;

import cn.tom.db.jdbc.DBOperations;
import cn.tom.db.jdbc.simple.DBUtil;
import cn.tom.kit.clazz.ReflectUtil;
import cn.tom.mvc.jdbc.DBPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DBTemplate
extends DBOperations {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObject(Connection conn, String sql, Object ... params) throws SQLException {
        try {
            Object object = DBUtil.getObject(DBUtil.query(conn, sql, params));
            return object;
        }
        finally {
            DBUtil.close(conn);
        }
    }

    @Override
    public <T> T queryForObject(String sql, Object ... params) throws SQLException {
        return (T)this.getObject(DBUtil.getConnection(), sql, params);
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> clazz, Object ... params) throws SQLException {
        Object obj = this.getObject(DBUtil.getConnection(), sql, params);
        return obj == null ? clazz.cast(null) : clazz.cast(ReflectUtil.covert(clazz, obj));
    }

    @Override
    public <T> T queryForObject(Connection conn, String sql, Class<T> clazz, Object ... params) throws SQLException {
        Object obj = DBUtil.getObject(DBUtil.query(conn, sql, params));
        return obj == null ? clazz.cast(null) : clazz.cast(ReflectUtil.covert(clazz, obj));
    }

    @Override
    public Long queryForLong(String sql, Object ... params) throws SQLException {
        return this.queryForObject(sql, Long.class, params);
    }

    @Override
    public Integer queryForInt(String sql, Object ... params) throws SQLException {
        return this.queryForObject(sql, Integer.class, params);
    }

    @Override
    public String queryForString(String sql, Object ... params) throws SQLException {
        return this.queryForObject(sql, String.class, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> getListT(Connection conn, String sql, Class<T> clazz, Object ... params) throws SQLException {
        try {
            List<T> list = DBUtil.getListT(DBUtil.query(conn, sql, params), clazz);
            return list;
        }
        finally {
            DBUtil.close(conn);
        }
    }

    @Override
    public <T> List<T> queryForList(Connection conn, String sql, Class<T> clazz, Object ... params) throws SQLException {
        return DBUtil.getListT(DBUtil.query(conn, sql, params), clazz);
    }

    @Override
    public <T> List<T> queryForList(String sql, Class<T> clazz, Object ... params) throws SQLException {
        return DBTemplate.getListT(DBUtil.getConnection(), sql, clazz, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getList(Connection conn, String sql, Class<? extends Map> clazz, Object ... params) throws SQLException {
        try {
            List<Map<String, Object>> list = DBUtil.getList(DBUtil.query(conn, sql, params), clazz);
            return list;
        }
        finally {
            DBUtil.close(conn);
        }
    }

    @Override
    public List<Map<String, Object>> queryForList(Connection conn, String sql, Object ... params) throws SQLException {
        return DBUtil.getList(DBUtil.query(conn, sql, params), HashMap.class);
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object ... params) throws SQLException {
        return this.getList(DBUtil.getConnection(), sql, HashMap.class, params);
    }

    @Override
    public List<Map<String, Object>> queryForLinkedMapList(String sql, Object ... params) throws SQLException {
        return this.getList(DBUtil.getConnection(), sql, LinkedHashMap.class, params);
    }

    @Override
    public Map<String, Object> queryForMap(Connection conn, String sql, Object ... params) throws SQLException {
        List<Map<String, Object>> list = this.queryForList(conn, sql, params);
        if (list.size() == 0) {
            return new HashMap<String, Object>();
        }
        return list.get(0);
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object ... params) throws SQLException {
        List<Map<String, Object>> list = this.queryForList(sql, params);
        if (list.size() == 0) {
            return new HashMap<String, Object>();
        }
        return list.get(0);
    }

    @Override
    public Map<String, Object> queryForLinkedMap(String sql) throws SQLException {
        return this.queryForLinkedMap(sql, new Object[0]);
    }

    @Override
    public Map<String, Object> queryForLinkedMap(String sql, Object ... params) throws SQLException {
        List<Map<String, Object>> list = this.queryForLinkedMapList(sql, params);
        if (list.size() == 0) {
            return new LinkedHashMap<String, Object>();
        }
        return list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(String sql, Object ... params) throws SQLException {
        Connection conn = DBUtil.getConnection();
        try {
            int n = this.update(conn, sql, params);
            return n;
        }
        finally {
            DBUtil.close(conn);
        }
    }

    @Override
    public int update(Connection conn, String sql, Object ... params) throws SQLException {
        if (DBPool.show_sql) {
            DBPool.logger.info(sql + " " + Arrays.asList(params));
        }
        PreparedStatement pst = conn.prepareStatement(sql);
        DBUtil.bindInputStatement(pst, params);
        return pst.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert(String sql, Object ... params) throws SQLException {
        Connection conn = DBUtil.getConnection();
        try {
            int n = this.insert(conn, sql, params);
            return n;
        }
        finally {
            DBUtil.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert(Connection conn, String sql, Object ... params) throws SQLException {
        if (DBPool.show_sql) {
            DBPool.logger.info(sql + " " + Arrays.asList(params));
        }
        PreparedStatement pst = conn.prepareStatement(sql, 1);
        DBUtil.bindInputStatement(pst, params);
        int r = pst.executeUpdate();
        try {
            ResultSet rs = pst.getGeneratedKeys();
            rs.next();
            int n = r = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            DBPool.logger.error("insert:", (Throwable)e);
            int n = r;
            return n;
        }
        finally {
            DBUtil.close(pst);
        }
    }

    @Override
    public int execute(String sql, Object ... params) throws SQLException {
        return this.update(sql, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] batchUpdate(String sql, List<Object[]> list) throws SQLException {
        int[] nArray;
        if (DBPool.show_sql) {
            DBPool.logger.info(sql + " " + list);
        }
        Connection conn = DBUtil.getConnection();
        PreparedStatement pst = null;
        try {
            conn.setAutoCommit(false);
            pst = conn.prepareStatement(sql);
            for (Object[] obj : list) {
                DBUtil.bindInputStatement(pst, obj);
                pst.addBatch();
            }
            int[] i = pst.executeBatch();
            conn.commit();
            nArray = i;
        }
        catch (Throwable throwable) {
            DBUtil.close(pst);
            DBUtil.close(conn);
            throw throwable;
        }
        DBUtil.close(pst);
        DBUtil.close(conn);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] batchUpdate(String sql, Object ... obj) throws SQLException {
        int[] nArray;
        if (DBPool.show_sql) {
            DBPool.logger.info(sql + " " + Arrays.asList(obj));
        }
        Connection conn = DBUtil.getConnection();
        PreparedStatement pst = null;
        try {
            conn.setAutoCommit(false);
            pst = conn.prepareStatement(sql);
            for (Object o : obj) {
                DBUtil.bindInputStatement(pst, o);
                pst.addBatch();
            }
            int[] i = pst.executeBatch();
            conn.commit();
            nArray = i;
        }
        catch (Throwable throwable) {
            DBUtil.close(pst);
            DBUtil.close(conn);
            throw throwable;
        }
        DBUtil.close(pst);
        DBUtil.close(conn);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] batchUpdate(List<String> list) throws SQLException {
        int[] nArray;
        Connection conn = DBUtil.getConnection();
        Statement stat = null;
        try {
            conn.setAutoCommit(false);
            stat = conn.createStatement();
            for (String sql : list) {
                stat.addBatch(sql);
            }
            int[] i = stat.executeBatch();
            conn.commit();
            nArray = i;
        }
        catch (Throwable throwable) {
            DBUtil.close(stat);
            DBUtil.close(conn);
            throw throwable;
        }
        DBUtil.close(stat);
        DBUtil.close(conn);
        return nArray;
    }
}

