/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.db.jdbc.simple;

import cn.tom.db.jdbc.Query;
import cn.tom.kit.StringUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DBQuery
implements Query {
    private StringBuffer sql = new StringBuffer();
    private List<Object> params = new ArrayList<Object>();

    public DBQuery(String execSql) {
        this.sql = this.sql.append(execSql);
    }

    public DBQuery(StringBuffer sql) {
        this.sql = sql;
    }

    @Override
    public Query setParams(Object obj) {
        this.params.add(obj);
        return this;
    }

    @Override
    public Query setParams(String obj) {
        return this.setParams((Object)obj);
    }

    @Override
    public Query setParams(int obj) {
        return this.setParams((Object)obj);
    }

    @Override
    public Query setParams(double obj) {
        return this.setParams((Object)obj);
    }

    @Override
    public Query setParams(float obj) {
        return this.setParams(Float.valueOf(obj));
    }

    @Override
    public Query setParams(long obj) {
        return this.setParams((Object)obj);
    }

    @Override
    public Query setParams(boolean obj) {
        return this.setParams((Object)obj);
    }

    @Override
    public Query setParams(Timestamp obj) {
        return this.setParams((Object)obj);
    }

    @Override
    public Query setParams(Date obj) {
        return this.setParams((Object)obj);
    }

    @Override
    public Query setParams(BigDecimal obj) {
        return this.setParams((Object)obj);
    }

    @Override
    public Object[] getParams() {
        return this.params.toArray();
    }

    @Override
    public String getSql() {
        return this.sql.toString();
    }

    @Override
    public Query upset(String upset) {
        if (this.params.size() > 0) {
            this.sql.append(",");
        }
        this.sql.append(upset);
        return this;
    }

    @Override
    public Query where(String where) {
        this.sql.append(" WHERE ").append(where);
        return this;
    }

    @Override
    public Query and(String where) {
        this.sql.append(" AND ").append(where);
        return this;
    }

    @Override
    public Query or(String where) {
        this.sql.append(" OR ").append(where);
        return this;
    }

    @Override
    public Query asc(String where) {
        this.sql.append(" ORDER BY ").append(where).append(" ASC ");
        return this;
    }

    @Override
    public Query desc(String where) {
        this.sql.append(" ORDER BY ").append(where).append(" DESC ");
        return this;
    }

    @Override
    public Query between(Object ... result) {
        if (result == null || result.length != 2) {
            throw new RuntimeException(" error between parameter... ");
        }
        this.sql.append(" BETWEEN ");
        for (int i = 0; i < result.length; ++i) {
            if (i > 0) {
                this.sql.append(" AND ");
            }
            this.sql.append(this.format(result[i]));
        }
        return this;
    }

    @Override
    public Query eq(Object result) {
        this.sql.append(" = ").append(this.format(result));
        return this;
    }

    @Override
    public Query notEq(Object result) {
        this.sql.append(" <> ").append(this.format(result));
        return this;
    }

    @Override
    public Query ge(Object result) {
        this.sql.append(" >= ").append(this.format(result));
        return this;
    }

    @Override
    public Query gt(Object result) {
        this.sql.append(" > ").append(this.format(result));
        return this;
    }

    @Override
    public Query in(Object ... result) {
        this.sql.append(" IN (");
        for (int i = 0; i < result.length; ++i) {
            if (i > 0) {
                this.sql.append(",");
            }
            this.sql.append(this.format(result[i]));
        }
        this.sql.append(" )");
        return this;
    }

    @Override
    public Query isNotNull() {
        this.sql.append(" IS NOT NULL ");
        return this;
    }

    @Override
    public Query isNull() {
        this.sql.append(" IS NULL ");
        return this;
    }

    @Override
    public Query le(Object result) {
        this.sql.append(" <= ").append(this.format(result));
        return this;
    }

    @Override
    public Query lt(Object result) {
        this.sql.append(" < ").append(this.format(result));
        return this;
    }

    @Override
    public Query like(String result) {
        this.sql.append(" LIKE ").append(this.format(result));
        return this;
    }

    @Override
    public Query not() {
        this.sql.append(" NOT ");
        return this;
    }

    @Override
    public Query and() {
        this.sql.append(" AND ");
        return this;
    }

    @Override
    public Query add(String _sql) {
        this.sql.append(_sql);
        return this;
    }

    @Override
    public Query append(String _sql) {
        this.sql.append(_sql);
        return this;
    }

    private Object format(Object obj) {
        if ("?".equals(String.valueOf(obj))) {
            return obj;
        }
        if (obj instanceof String) {
            obj = "'" + StringUtil.escapeSql(obj.toString()) + "'";
        } else if (obj instanceof Timestamp) {
            obj = "'" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(obj) + "'";
        } else if (obj instanceof Date) {
            obj = "'" + new SimpleDateFormat("yyyy-MM-dd").format(obj) + "'";
        }
        return obj;
    }
}

