/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.db.jdbc;

import cn.tom.db.jdbc.ProceRecord;
import cn.tom.db.jdbc.simple.DBUtil;
import cn.tom.db.jdbc.simple.ProceUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class ProcedureCallback {
    String str_sql = null;
    Map<Integer, Object[]> paramsMap = new LinkedHashMap<Integer, Object[]>();

    protected void registerInParameter() {
        this.paramsMap.put(this.paramsMap.size() + 1, null);
    }

    protected void registerOutParameter(String type, String name) {
        this.paramsMap.put(this.paramsMap.size() + 1, new Object[]{name, type});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProceRecord doInCallback(Connection conn, String sql, Object ... objects) throws SQLException {
        this.str_sql = this.parse(sql);
        CallableStatement cs = null;
        cs = conn.prepareCall(this.str_sql);
        try {
            for (int i = 0; i < this.paramsMap.size(); ++i) {
                Integer key = i + 1;
                Object[] p = this.paramsMap.get(key);
                if (p == null) {
                    if (objects == null || i >= objects.length) {
                        throw new IllegalArgumentException("not enought parameter");
                    }
                    ProceUtils.bindStatementInput(cs, key, objects[i]);
                    continue;
                }
                String type = (String)p[1];
                ProceUtils.bindStatementOutput(cs, key, type);
            }
            ProceRecord proceRecord = this.getResult(cs, cs.execute());
            return proceRecord;
        }
        finally {
            DBUtil.close(conn);
        }
    }

    public String parse(String sql) {
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProceRecord getResult(CallableStatement cstmt, boolean executeResult) throws SQLException {
        LinkedHashMap<String, Object> retmap = new LinkedHashMap<String, Object>();
        int index = 0;
        if (executeResult) {
            ResultSet rs = null;
            try {
                rs = cstmt.getResultSet();
                retmap.put("DATASET_" + index++, ProceUtils.convertResultSetToMapList(rs, false));
                while (cstmt.getMoreResults()) {
                    rs = cstmt.getResultSet();
                    retmap.put("DATASET_" + index++, ProceUtils.convertResultSetToMapList(rs, false));
                }
            }
            finally {
                DBUtil.close(rs);
            }
        }
        for (int i = 0; i < this.paramsMap.size(); ++i) {
            Integer key = i + 1;
            Object[] p = this.paramsMap.get(key);
            if (p == null) continue;
            String name = (String)p[0];
            String type = (String)p[1];
            retmap.put(name.toUpperCase(), ProceUtils.convertType(cstmt, key, type));
        }
        return new ProceRecord(retmap);
    }
}

