/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.ext;

import cn.tom.mvc.config.Constants;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Scan {
    public static Set<Class<?>> scanpackage(String packName) {
        LinkedHashSet clazzs = new LinkedHashSet();
        String packageDirName = packName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), Constants.getEncoding());
                    Scan.getFileClass(packName, filePath, clazzs);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                Scan.getJarClass(jarFile, packageDirName, clazzs);
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        return clazzs;
    }

    public static void getFileClass(String packName, String filePath, Set<Class<?>> clazzs) {
        File[] dirFiles;
        File dir = new File(filePath);
        if (!dir.exists() || !dir.isDirectory()) {
            System.out.println("\u5305\u76ee\u5f55\u4e0d\u5b58\u5728!");
            return;
        }
        File[] fileArray = dirFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".class");
            }
        });
        int n = dirFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                Scan.getFileClass(String.valueOf(packName) + "." + file.getName(), file.getAbsolutePath(), clazzs);
            } else {
                String className = file.getName().substring(0, file.getName().length() - 6);
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(String.valueOf(packName) + "." + className);
                    clazzs.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public static void getJarClass(JarFile jarFile, String filepath, Set<Class<?>> clazzs) throws IOException {
        ArrayList<JarEntry> jarEntryList = new ArrayList<JarEntry>();
        Enumeration<JarEntry> enumes = jarFile.entries();
        while (enumes.hasMoreElements()) {
            JarEntry entry = enumes.nextElement();
            if (!entry.getName().startsWith(filepath) || !entry.getName().endsWith(".class")) continue;
            jarEntryList.add(entry);
        }
        for (JarEntry entry : jarEntryList) {
            String className = entry.getName().replace('/', '.');
            className = className.substring(0, className.length() - 6);
            try {
                clazzs.add(Thread.currentThread().getContextClassLoader().loadClass(className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

