/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.ext;

import cn.tom.mvc.core.CocookException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class BeanFactory {
    public static final ConcurrentHashMap<String, Object> singletons = new ConcurrentHashMap();

    public static <T> T getInstance(Class<T> _class) {
        String key = _class.getName();
        if (singletons.containsKey(key)) {
            return _class.cast(singletons.get(key));
        }
        try {
            T tt = _class.newInstance();
            singletons.put(key, tt);
            return tt;
        }
        catch (Exception e) {
            throw new CocookException(e);
        }
    }

    public static Object getInstance(String _class) {
        if (singletons.containsKey(_class)) {
            return singletons.get(_class);
        }
        try {
            Class<?> clazz = BeanFactory.loadClass(_class);
            Object tt = clazz.newInstance();
            singletons.put(_class, tt);
            return tt;
        }
        catch (Exception e) {
            throw new CocookException(e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new CocookException(e);
        }
    }

    public static Object newInstance(String _class) {
        try {
            Class<?> clazz = BeanFactory.loadClass(_class);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new CocookException(e);
        }
    }

    public static Class<?> loadClass(String _clazz) throws ClassNotFoundException {
        Class<?> clazz = BeanFactory.class.getClassLoader().loadClass(_clazz);
        if (clazz == null) {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(_clazz);
        }
        return clazz;
    }

    public static Object invoke(Method me, Object obj, Object ... params) {
        try {
            return me.invoke(obj, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

