/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.db.mongo;

import cn.tom.kit.clazz.ReflectUtil;
import cn.tom.kit.io.FileUtil;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDB {
    private String db;
    private String hosts;
    private String username;
    private String password;
    private int port;
    private int connectionsPerHost;
    private int threadsAllowedToBlockForConnectionMultiplier;
    private boolean autoConnectRetry;
    private int maxWaitTime;
    private Logger logger;
    private MongoClient client;

    public MongoDB() {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.client = null;
    }

    public MongoDB(String db, String hosts, int port, int connectionsPerHost, int threadsAllowedToBlockForConnectionMultiplier, boolean autoConnectRetry, int maxWaitTime) {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.client = null;
        this.db = db;
        this.hosts = hosts;
        this.port = port;
        this.connectionsPerHost = connectionsPerHost;
        this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
        this.autoConnectRetry = autoConnectRetry;
        this.maxWaitTime = maxWaitTime;
    }

    public MongoDB(File file) {
        block5: {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.client = null;
            Properties pro = new Properties();
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(file);
                    pro.load(in);
                    ReflectUtil.populate(this, pro);
                }
                catch (IOException e) {
                    this.logger.info("read MongoDbconfig error", (Throwable)e);
                    FileUtil.close(in, null);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(in, null);
                throw throwable;
            }
            FileUtil.close(in, null);
        }
        this.init();
    }

    public void init(Properties pro) {
        ReflectUtil.populate(this, pro);
        this.init();
    }

    public void init() {
        try {
            this.client = new MongoClient(this.getServerAddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        MongoOptions options = this.client.getMongoOptions();
        options.setConnectionsPerHost(this.getConnectionsPerHost());
        options.setThreadsAllowedToBlockForConnectionMultiplier(this.getThreadsAllowedToBlockForConnectionMultiplier());
        options.setAutoConnectRetry(this.isAutoConnectRetry());
        this.logger.info("init MongoDb success --> " + this.client);
    }

    public void cleanUp() {
        System.out.println("------cleanUp--------");
    }

    public DB getDB() {
        DB db = this.client.getDB(this.getDb());
        db.authenticate(this.username, this.password.toCharArray());
        return db;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public List<ServerAddress> getServerAddress() throws UnknownHostException {
        ArrayList<ServerAddress> list = new ArrayList<ServerAddress>(5);
        String[] stringArray = this.hosts.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String host = stringArray[n2];
            ServerAddress address = new ServerAddress(host, this.port);
            list.add(address);
            ++n2;
        }
        return list;
    }

    public int getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    public void setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
    }

    public int getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier;
    }

    public void setThreadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
        this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
    }

    public boolean isAutoConnectRetry() {
        return this.autoConnectRetry;
    }

    public void setAutoConnectRetry(boolean autoConnectRetry) {
        this.autoConnectRetry = autoConnectRetry;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getDb() {
        return this.db;
    }
}

