package cn.tom.mvc.view;

import java.util.HashMap;

import cn.tom.mvc.config.Constants;
import cn.tom.mvc.ext.BeanFactory;

public class DefaultViewFactory extends ViewFactory{

	private final static HashMap<String, Class<? extends View>> views = new HashMap<String, Class<? extends View>>() ; 
	private String viewType  = getViewType();
	static{
		views.put("velocity", VelocityView.class);
		views.put("freemarker", FreeMarkerView.class);
	}
	
	@Override
	public View create() {
		Class<? extends View> clazz =  views.get(viewType);
		if(clazz == null) return null;
		View view;
		try {
			view =  BeanFactory.newInstance(clazz);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		} 
		return view;
	}
	
	
	private String getViewType(){
		return Constants.getViewType();
	}
	
}
