package cn.tom.mvc.handler;

import cn.tom.mvc.annotation.HttpMethod;

public class RequestMapping {
	
	private String path;
	private HttpMethod method;
	
	public RequestMapping() {
	}
	
	public RequestMapping(String path, HttpMethod method) {
		this.path = path;
		this.method = method;
	}

	public String getPath() {
		return path;
	}
	public void setPath(String path) {
		this.path = path;
	}
	
	public HttpMethod getMethod() {
		return method;
	}
	public void setMethod(HttpMethod method) {
		this.method = method;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((method == null) ? 0 : method.hashCode());
		result = prime * result + ((path == null) ? 0 : path.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		RequestMapping other = (RequestMapping) obj;
		if (method != other.method)
			return false;
		if (path == null) {
			if (other.path != null)
				return false;
		} else if (!path.equals(other.path))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "RequestMapping [path=" + path + ", method=" + method + "]";
	}
	



}
