/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.view;

import cn.tom.mvc.config.Constants;
import cn.tom.mvc.core.RequestContext;
import cn.tom.mvc.view.View;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.util.SimplePool;

public class VelocityView
extends View {
    private static SimplePool writerPool = new SimplePool(40);
    private static final String encoding = Constants.getEncoding();

    @Override
    public void init() {
        Properties properties = VelocityView.config();
        String velocityLoadPath = Constants.getWebRoot();
        if (properties != null) {
            properties.setProperty("file.resource.loader.path", velocityLoadPath);
            properties.setProperty("input.encoding", encoding);
            properties.setProperty("output.encoding", encoding);
            RuntimeSingleton.init((Properties)properties);
            return;
        }
        properties = new Properties();
        properties.setProperty("file.resource.loader.path", velocityLoadPath);
        properties.setProperty("input.encoding", encoding);
        properties.setProperty("output.encoding", encoding);
        RuntimeSingleton.init((Properties)properties);
    }

    @Override
    public void render(String view) {
        block15: {
            VelocityWriter vw;
            block16: {
                RequestContext requestContext = RequestContext.get();
                HttpServletResponse res = requestContext.getResponse();
                res.setContentType("text/html;charset=" + encoding);
                res.setCharacterEncoding(encoding);
                vw = null;
                try {
                    Template template = RuntimeSingleton.getTemplate((String)view);
                    VelocityContext context = new VelocityContext(requestContext.getAttributsMap());
                    ServletOutputStream output = res.getOutputStream();
                    vw = (VelocityWriter)writerPool.get();
                    if (vw == null) {
                        vw = new VelocityWriter((Writer)new OutputStreamWriter((OutputStream)output, encoding), 4096, true);
                    } else {
                        vw.recycle((Writer)new OutputStreamWriter((OutputStream)output, encoding));
                    }
                    template.merge((Context)context, (Writer)vw);
                    vw.flush();
                }
                catch (ResourceNotFoundException ee) {
                    try {
                        requestContext.error(404, ee.toString());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (vw != null) {
                        vw.recycle(null);
                    }
                    writerPool.put(vw);
                    break block15;
                }
                catch (Exception e) {
                    try {
                        try {
                            this.error(res, e);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (vw != null) {
                            vw.recycle(null);
                        }
                        writerPool.put(vw);
                    }
                }
                if (vw == null) break block16;
                vw.recycle(null);
            }
            writerPool.put((Object)vw);
        }
    }

    private void error(HttpServletResponse response, Exception cause) throws IOException {
        StringBuffer html = new StringBuffer();
        html.append("<html>");
        html.append("<title>Error</title>");
        html.append("<body bgcolor=\"#ffffff\">");
        html.append("<h2>You know: Error processing the template</h2>");
        html.append("<xmp>");
        StringWriter sw = new StringWriter();
        cause.printStackTrace(new PrintWriter(sw));
        html.append(sw.toString());
        html.append("</xmp>");
        html.append("</body>");
        html.append("</html>");
        response.getOutputStream().print(html.toString());
    }
}

