/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.jdbc;

import cn.tom.kit.Encrypt;
import cn.tom.kit.clazz.ReflectUtil;
import cn.tom.kit.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBPool {
    private DataSource dataSource;
    public String driverClass;
    private String username;
    private String password;
    private static final ThreadLocal<Connection> conns = new ThreadLocal();
    private File dbFile;
    private int flag = 0;
    public static Logger logger = LoggerFactory.getLogger(DBPool.class);
    public static boolean show_sql = false;

    public DBPool() {
    }

    public DBPool(File dbFile) {
        this.dbFile = dbFile;
        this.init();
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public void init(Properties prop) {
        ++this.flag;
        logger.info("init connection " + this.flag + " times");
        try {
            this.driverClass = prop.getProperty("driverClassName");
            show_sql = Boolean.parseBoolean(prop.getProperty("show_sql"));
            String encrypt = prop.getProperty("encrypt");
            prop.remove("show_sql");
            prop.remove("encrypt");
            this.username = prop.getProperty("username");
            this.password = prop.getProperty("password");
            if (encrypt != null && !encrypt.isEmpty()) {
                prop.setProperty("password", Encrypt.decryptString(2, this.password));
            }
            this.dataSource = (DataSource)Thread.currentThread().getContextClassLoader().loadClass(prop.getProperty("dataSource")).newInstance();
            prop.remove("dataSource");
            ReflectUtil.populate(this.dataSource, prop);
            Connection conn = this.getConnection();
            DatabaseMetaData mdm = conn.getMetaData();
            logger.info("connect database success: " + mdm.getDatabaseProductName() + mdm.getDatabaseProductVersion());
            this.closeConnection(conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("init connection failed in " + this.flag + " times");
        }
    }

    public void init() {
        Properties prop;
        block5: {
            prop = new Properties();
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(this.dbFile);
                    prop.load(in);
                }
                catch (IOException e) {
                    logger.info("read dbconfig error", (Throwable)e);
                    FileUtil.close(in, null);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(in, null);
                throw throwable;
            }
            FileUtil.close(in, null);
        }
        this.init(prop);
    }

    public final void closeDataSource() {
        try {
            if (this.dataSource == null) {
                return;
            }
            this.dataSource.getClass().getMethod("close", new Class[0]).invoke((Object)this.dataSource, new Object[0]);
            this.dataSource = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final Connection proxyConn(Connection conn) {
        return show_sql && !Proxy.isProxyClass(conn.getClass()) ? new _DebugConnection().bindConnection(conn) : conn;
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.info("init connection failed, init again..." + e.toString());
            this.init();
            try {
                return this.dataSource.getConnection();
            }
            catch (SQLException ee) {
                logger.info("init connection faild, check DBconfig!" + ee.toString());
                throw ee;
            }
        }
    }

    @Deprecated
    public final Connection getThreadConnection() {
        Connection conn = conns.get();
        try {
            if (conn == null || conn.isClosed()) {
                conn = this.getConnection();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conns.set(conn);
        return this.proxyConn(conn);
    }

    @Deprecated
    public final void closeThreadConnection() {
        Connection conn = conns.get();
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conns.remove();
    }

    public final void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static class _DebugConnection
    implements InvocationHandler {
        private Connection conn = null;

        _DebugConnection() {
        }

        public Connection bindConnection(Connection conn) {
            this.conn = conn;
            return (Connection)Proxy.newProxyInstance(conn.getClass().getClassLoader(), conn.getClass().getInterfaces(), (InvocationHandler)this);
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            String methodName = m.getName();
            if ("prepareStatement".equals(methodName) || "prepareCall".equals(methodName)) {
                logger.info("[SQL]>> " + args[0]);
            }
            try {
                return m.invoke((Object)this.conn, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

