/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.interceptor;

import cn.tom.mvc.config.Constants;
import cn.tom.mvc.core.ControllerModel;
import cn.tom.mvc.core.RequestContext;
import cn.tom.mvc.handler.HandlerInfo;
import cn.tom.mvc.handler.RequestMapping;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ActionInvocation {
    private transient HandlerInfo handlerInfo;
    private transient RequestContext context = RequestContext.get();
    private transient Map<String, String> params;
    private transient RequestMapping mapping;

    public ActionInvocation(HandlerInfo handlerInfo, RequestMapping mapping) {
        this.handlerInfo = handlerInfo;
        this.params = this.mergreParams();
        this.mapping = mapping;
    }

    private Map<String, String> mergreParams() {
        try {
            this.context.setCharacterEncoding(Constants.getEncoding());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map<String, String> map = this.context.getParameterMap();
        map.putAll(this.context.getUrlMap());
        return map;
    }

    public RequestContext getRequestContext() {
        return this.context;
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public HttpSession getSession() {
        return this.context.getSession();
    }

    public HttpServletRequest getRequest() {
        return this.context.getRequest();
    }

    public HttpServletResponse getResponse() {
        return this.context.getResponse();
    }

    public Map<String, String> getParaMap() {
        return this.params;
    }

    public ControllerModel getAppControl() {
        return this.handlerInfo.getController();
    }

    public HandlerInfo getHandlerInfo() {
        return this.handlerInfo;
    }

    public Method getMethod() {
        return this.getHandlerInfo().getMethods().get(this.mapping);
    }

    public RequestMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(RequestMapping mapping) {
        this.mapping = mapping;
    }

    public void recycle() {
        this.handlerInfo = null;
        this.params = null;
    }
}

