/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.kit.clazz;

import cn.tom.kit.clazz.Converter;
import cn.tom.mvc.core.CocookException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class ReflectUtil {
    public static FieldFilter COPYABLE_FIELDS = new FieldFilter(){

        @Override
        public boolean matches(Field field) {
            return !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
        }
    };
    public static MethodFilter NON_BRIDGED_METHODS = new MethodFilter(){

        @Override
        public boolean matches(Method method) {
            return !method.isBridge();
        }
    };
    public static MethodFilter USER_DECLARED_METHODS = new MethodFilter(){

        @Override
        public boolean matches(Method method) {
            return !method.isBridge() && method.getDeclaringClass() != Object.class;
        }
    };

    public static String toTitleCase(String name) {
        return String.valueOf(Character.toTitleCase(name.charAt(0))) + name.substring(1);
    }

    public static String toSetMethod(String name) {
        return "set" + ReflectUtil.toTitleCase(name);
    }

    public static String toGetMethod(String name) {
        return "get" + ReflectUtil.toTitleCase(name);
    }

    public static Object invokeMethodByConvert(Object object, Method method, Object ... params) {
        ReflectUtil.convert(method, params);
        try {
            return method.invoke(object, params);
        }
        catch (Exception e) {
            throw new CocookException(e);
        }
    }

    public static Object invokeMethod(Object object, Method method, Object ... params) {
        try {
            return method.invoke(object, params);
        }
        catch (Exception e) {
            throw new CocookException(e);
        }
    }

    public static Object[] convert(Method method, Object ... params) {
        Class<?>[] _class = method.getParameterTypes();
        if (_class.length != params.length) {
            return params;
        }
        int i = 0;
        while (i < params.length) {
            params[i] = ReflectUtil.covert(_class[i], params[i]);
            ++i;
        }
        return params;
    }

    public static Object covert(Class<?> _class, Object param) {
        if (param == null) {
            return null;
        }
        Class<?> clazz = param.getClass();
        if (Converter.convertType2Class(_class) == clazz || _class.isAssignableFrom(clazz)) {
            return param;
        }
        if (Converter.canConvertValue(_class)) {
            return Converter.coverterClass2Value(_class, null, param.toString());
        }
        return param.toString();
    }

    public static Method getDeclaredMethod(Object object, String methodName, Class<?>[] parameterTypes) {
        Class<?> superClass = object.getClass();
        while (superClass != Object.class) {
            try {
                return superClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                superClass = superClass.getSuperclass();
            }
        }
        return null;
    }

    public static Method getDeclaredMethod(Class<?> _class, String methodName) {
        Method[] m = _class.getDeclaredMethods();
        Method me = null;
        int i = 0;
        while (i < m.length) {
            if (m[i].getModifiers() == 1 && m[i].getName().equals(methodName)) {
                me = m[i];
                break;
            }
            ++i;
        }
        return me;
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Class _class = Object.class;
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return _class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (params.length == 0) {
            return _class;
        }
        try {
            _class = (Class)params[index];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _class;
    }

    public static <T> T mapToBean(Map<String, ?> map, Class<T> _class) {
        T t;
        try {
            t = _class.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        for (String key : map.keySet()) {
            Object value = map.get(key);
            String methodName = ReflectUtil.toSetMethod(key);
            Method method = ReflectUtil.getDeclaredMethod(_class, methodName);
            if (method == null) continue;
            ReflectUtil.invokeMethodByConvert(t, method, value);
        }
        return t;
    }

    public static Map<String, Object> beanToMap(Object bean) {
        PropertyDescriptor[] pros;
        BeanInfo info = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            info = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
        PropertyDescriptor[] propertyDescriptorArray = pros = info.getPropertyDescriptors();
        int n = pros.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pro = propertyDescriptorArray[n2];
            String name = pro.getName();
            if (!"class".equals(name)) {
                Method method = pro.getReadMethod();
                try {
                    Object result = method.invoke(bean, new Object[0]);
                    if (result != null) {
                        map.put(name, result);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return map;
    }

    public static boolean isVisible(Class<?> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            Class<?> actualClass = classLoader.loadClass(clazz.getName());
            return clazz == actualClass;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        return ReflectUtil.getAllInterfacesForClass(clazz, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz, ClassLoader classLoader) {
        Set<Class> ifcs = ReflectUtil.getAllInterfacesForClassAsSet(clazz, classLoader);
        return ifcs.toArray(new Class[ifcs.size()]);
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz, ClassLoader classLoader) {
        if (clazz.isInterface() && ReflectUtil.isVisible(clazz, classLoader)) {
            return Collections.singleton(clazz);
        }
        LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
        while (clazz != null) {
            Class<?>[] ifcs;
            Class<?>[] classArray = ifcs = clazz.getInterfaces();
            int n = ifcs.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> ifc = classArray[n2];
                interfaces.addAll(ReflectUtil.getAllInterfacesForClassAsSet(ifc, classLoader));
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static void populate(Object obj, Properties prop) {
        for (String string : prop.keySet()) {
            String value = prop.getProperty(string);
            String methodName = ReflectUtil.toSetMethod(string);
            Method method = ReflectUtil.findMethod(obj.getClass(), methodName);
            if (method == null) {
                System.out.println("method is null = " + methodName);
                continue;
            }
            ReflectUtil.invokeMethodByConvert(obj, method, value);
        }
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectUtil.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        Class<?> searchType = clazz;
        while (!Object.class.equals(searchType) && searchType != null) {
            Field[] fields;
            Field[] fieldArray = fields = searchType.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if ((name == null || name.equals(field.getName())) && (type == null || type.equals(field.getType()))) {
                    return field;
                }
                ++n2;
            }
            searchType = searchType.getSuperclass();
        }
        return null;
    }

    public static void setField(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            ReflectUtil.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Object getField(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            ReflectUtil.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectUtil.findMethod(clazz, name, new Class[0]);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        Class<?> searchType = clazz;
        while (searchType != null) {
            Method[] methods;
            Method[] methodArray = methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (name.equals(method.getName()) && (paramTypes.length == 0 || Arrays.equals(paramTypes, method.getParameterTypes()))) {
                    return method;
                }
                ++n2;
            }
            searchType = searchType.getSuperclass();
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectUtil.invokeMethod(method, target, new Object[0]);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectUtil.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object invokeJdbcMethod(Method method, Object target) throws SQLException {
        return ReflectUtil.invokeJdbcMethod(method, target, new Object[0]);
    }

    public static Object invokeJdbcMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectUtil.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        ReflectUtil.handleUnexpectedException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectUtil.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        ReflectUtil.handleUnexpectedException(ex);
    }

    public static void rethrowException(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        ReflectUtil.handleUnexpectedException(ex);
    }

    private static void handleUnexpectedException(Throwable ex) {
        throw new IllegalStateException("Unexpected exception thrown", ex);
    }

    public static boolean declaresException(Method method, Class<?> exceptionType) {
        Class<?>[] declaredExceptions;
        Class<?>[] classArray = declaredExceptions = method.getExceptionTypes();
        int n = declaredExceptions.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> declaredException = classArray[n2];
            if (declaredException.isAssignableFrom(exceptionType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) throws IllegalArgumentException {
        ReflectUtil.doWithMethods(clazz, mc, null);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc, MethodFilter mf) throws IllegalArgumentException {
        Method[] methods = clazz.getDeclaredMethods();
        GenericDeclaration[] genericDeclarationArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = genericDeclarationArray[n2];
            if (mf == null || mf.matches(method)) {
                try {
                    mc.doWith(method);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + ex);
                }
            }
            ++n2;
        }
        if (clazz.getSuperclass() != null) {
            ReflectUtil.doWithMethods(clazz.getSuperclass(), mc, mf);
        } else if (clazz.isInterface()) {
            genericDeclarationArray = clazz.getInterfaces();
            n = genericDeclarationArray.length;
            n2 = 0;
            while (n2 < n) {
                GenericDeclaration superIfc = genericDeclarationArray[n2];
                ReflectUtil.doWithMethods(superIfc, mc, mf);
                ++n2;
            }
        }
    }

    public static void doWithMethodsWithNoRecursion(Class<?> clazz, MethodCallback mc, MethodFilter mf) throws IllegalArgumentException {
        Method[] methods;
        Method[] methodArray = methods = clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (mf == null || mf.matches(method)) {
                try {
                    mc.doWith(method);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + ex);
                }
            }
            ++n2;
        }
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) throws IllegalArgumentException {
        final ArrayList methods = new ArrayList(32);
        ReflectUtil.doWithMethods(leafClass, new MethodCallback(){

            @Override
            public void doWith(Method method) {
                methods.add(method);
            }
        });
        return methods.toArray(new Method[methods.size()]);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) throws IllegalArgumentException {
        ReflectUtil.doWithFields(clazz, fc, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc, FieldFilter ff) throws IllegalArgumentException {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            Field[] fieldArray = fields = targetClass.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (ff == null || ff.matches(field)) {
                    try {
                        fc.doWith(field);
                    }
                    catch (IllegalAccessException ex) {
                        throw new IllegalStateException("Shouldn't be illegal to access field '" + field.getName() + "': " + ex);
                    }
                }
                ++n2;
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    public static void shallowCopyFieldState(final Object src, final Object dest) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("Source for field copy cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Destination for field copy cannot be null");
        }
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ReflectUtil.doWithFields(src.getClass(), new FieldCallback(){

            @Override
            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ReflectUtil.makeAccessible(field);
                Object srcValue = field.get(src);
                field.set(dest, srcValue);
            }
        }, COPYABLE_FIELDS);
    }

    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }
}

