/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.kit.clazz;

import cn.tom.kit.clazz.BridgeMethodResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;

public class AnnotationUtils {
    static final String VALUE = "value";
    private static final Map<Class, Boolean> annotatedInterfaceCache = new WeakHashMap<Class, Boolean>();

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        Class<?> superClass;
        A annotation = clazz.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        Object[] objectArray = clazz.getInterfaces();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> ifc = objectArray[n2];
            annotation = AnnotationUtils.findAnnotation(ifc, annotationType);
            if (annotation != null) {
                return annotation;
            }
            ++n2;
        }
        if (!Annotation.class.isAssignableFrom(clazz)) {
            objectArray = clazz.getAnnotations();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object ann = objectArray[n2];
                annotation = AnnotationUtils.findAnnotation(ann.annotationType(), annotationType);
                if (annotation != null) {
                    return annotation;
                }
                ++n2;
            }
        }
        if ((superClass = clazz.getSuperclass()) == null || superClass == Object.class) {
            return null;
        }
        return AnnotationUtils.findAnnotation(superClass, annotationType);
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        A annotation = AnnotationUtils.getAnnotation(method, annotationType);
        Class<?> cl = method.getDeclaringClass();
        if (annotation == null) {
            annotation = AnnotationUtils.searchOnInterfaces(method, annotationType, cl.getInterfaces());
        }
        while (annotation == null) {
            if ((cl = cl.getSuperclass()) == null || cl == Object.class) break;
            try {
                Method equivalentMethod = cl.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
                if (annotation != null) continue;
                annotation = AnnotationUtils.searchOnInterfaces(method, annotationType, cl.getInterfaces());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return annotation;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
        A ann = resolvedMethod.getAnnotation(annotationType);
        if (ann == null) {
            Annotation[] annotationArray = resolvedMethod.getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation metaAnn = annotationArray[n2];
                ann = metaAnn.annotationType().getAnnotation(annotationType);
                if (ann != null) break;
                ++n2;
            }
        }
        return ann;
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, Class<A> annotationType, Class[] ifcs) {
        A annotation = null;
        Class[] classArray = ifcs;
        int n = ifcs.length;
        int n2 = 0;
        while (n2 < n) {
            Class iface = classArray[n2];
            if (AnnotationUtils.isInterfaceWithAnnotatedMethods(iface)) {
                try {
                    Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                    annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (annotation != null) break;
            }
            ++n2;
        }
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterfaceWithAnnotatedMethods(Class<?> iface) {
        Map<Class, Boolean> map = annotatedInterfaceCache;
        synchronized (map) {
            Boolean flag = annotatedInterfaceCache.get(iface);
            if (flag != null) {
                return flag;
            }
            boolean found = false;
            Method[] methodArray = iface.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method ifcMethod = methodArray[n2];
                if (ifcMethod.getAnnotations().length > 0) {
                    found = true;
                    break;
                }
                ++n2;
            }
            annotatedInterfaceCache.put(iface, found);
            return found;
        }
    }

    public static Object getValue(Annotation annotation, String attributeName) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getValue(Annotation annotation) {
        return AnnotationUtils.getValue(annotation, VALUE);
    }
}

