/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.kit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Helper {
    public static String getLocalIp() {
        try {
            Pattern pattern = Pattern.compile("(192|172|10)\\.[0-9]+\\.[0-9]+\\.[0-9]+");
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> en = ni.getInetAddresses();
                while (en.hasMoreElements()) {
                    InetAddress addr = en.nextElement();
                    String ip = addr.getHostAddress();
                    Matcher matcher = pattern.matcher(ip);
                    if (!matcher.matches()) continue;
                    return ip;
                }
            }
            return "0.0.0.0";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0.0.0.0";
        }
    }

    public static InputStream loadFile(String resource, Class<?> clazz) {
        block7: {
            URL url;
            block8: {
                ClassLoader classLoader = null;
                try {
                    Method method = Thread.class.getMethod("getContextClassLoader", new Class[0]);
                    classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
                }
                catch (Exception e) {
                    System.out.println("loadConfigFile error: ");
                    e.printStackTrace();
                }
                if (classLoader == null) {
                    classLoader = clazz.getClassLoader();
                }
                if (classLoader == null) break block7;
                url = classLoader.getResource(resource);
                if (url != null) break block8;
                System.out.println("Can not find resource:" + resource);
                return null;
            }
            try {
                if (url.toString().startsWith("jar:file:")) {
                    return clazz.getResourceAsStream(resource.startsWith("/") ? resource : "/" + resource);
                }
                return new FileInputStream(new File(url.toURI()));
            }
            catch (Exception e) {
                System.out.println("loadConfigFile error: ");
                e.printStackTrace();
            }
        }
        return null;
    }

    public static InputStream loadFile(String resource) {
        block7: {
            URL url;
            block8: {
                ClassLoader classLoader = null;
                try {
                    Method method = Thread.class.getMethod("getContextClassLoader", new Class[0]);
                    classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
                }
                catch (Exception e) {
                    System.out.println("loadConfigFile error: ");
                    e.printStackTrace();
                }
                if (classLoader == null) {
                    classLoader = Helper.class.getClassLoader();
                }
                if (classLoader == null) break block7;
                url = classLoader.getResource(resource);
                if (url != null) break block8;
                System.out.println("Can not find resource:" + resource);
                return null;
            }
            try {
                if (url.toString().startsWith("jar:file:")) {
                    return Helper.class.getResourceAsStream(resource.startsWith("/") ? resource : "/" + resource);
                }
                return new FileInputStream(new File(url.toURI()));
            }
            catch (Exception e) {
                System.out.println("loadConfigFile error: ");
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String loadFileContent(String resource) {
        StringWriter writer;
        block17: {
            InputStream in = Helper.class.getClassLoader().getResourceAsStream(resource);
            if (in == null) {
                return "";
            }
            writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                break block17;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ((Object)writer).toString();
    }

    public static String option(Properties props, String opt, String defaultValue) {
        String value = props.getProperty(opt, defaultValue);
        return value == null ? null : value.trim();
    }

    public static int option(Properties props, String opt, int defaultValue) {
        String value = Helper.option(props, opt, null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public static String option(String[] args, String opt, String defaultValue) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(opt) && i < args.length - 1) {
                return args[i + 1];
            }
            ++i;
        }
        return defaultValue;
    }

    public static int option(String[] args, String opt, int defaultValue) {
        String value = Helper.option(args, opt, null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public static boolean option(String[] args, String opt, boolean defaultValue) {
        String value = Helper.option(args, opt, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static String remoteAddress(SocketChannel channel) {
        SocketAddress addr = channel.socket().getRemoteSocketAddress();
        String res = String.format("%s", addr);
        return res;
    }

    public static String localAddress(SocketChannel channel) {
        SocketAddress addr = channel.socket().getLocalSocketAddress();
        String res = String.format("%s", addr);
        return addr == null ? res : res.substring(1);
    }
}

