/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.db.jdbc.simple;

import cn.tom.db.jdbc.ProceRecord;
import cn.tom.db.jdbc.ProcedureCallback;
import cn.tom.kit.StringUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProceUtils {
    public static List<Map<String, Object>> convertResultSetToMapList(ResultSet rs, Boolean toLowerCase) {
        ArrayList<Map<String, Object>> resultListMap;
        block16: {
            resultListMap = new ArrayList<Map<String, Object>>();
            if (rs == null) {
                return resultListMap;
            }
            try {
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int columnCount = rsmd.getColumnCount();
                    while (rs.next()) {
                        LinkedHashMap<String, Clob> rowMap = new LinkedHashMap<String, Clob>();
                        int i = 1;
                        while (i <= columnCount) {
                            Object colValue = null;
                            String colName = rsmd.getColumnName(i);
                            if (toLowerCase.booleanValue()) {
                                colName = colName.toLowerCase();
                            }
                            colValue = rsmd.getColumnType(i) == 2005 ? rs.getClob(i) : (rsmd.getColumnType(i) == 2004 ? rs.getBlob(i) : rs.getObject(i));
                            rowMap.put(colName, (Clob)colValue);
                            ++i;
                        }
                        resultListMap.add(rowMap);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    if (rs == null) break block16;
                    try {
                        rs.close();
                    }
                    catch (SQLException e2) {
                        rs = null;
                    }
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        rs = null;
                    }
                }
            }
        }
        return resultListMap;
    }

    public static void bindStatementInput(CallableStatement cs, int indexed, Object value) throws SQLException {
        if (value instanceof String) {
            cs.setString(indexed, (String)value);
        } else if (value instanceof Integer) {
            cs.setInt(indexed, (int)((Integer)value));
        } else if (value instanceof Double) {
            cs.setDouble(indexed, (double)((Double)value));
        } else if (value instanceof Float) {
            cs.setFloat(indexed, ((Float)value).floatValue());
        } else if (value instanceof Long) {
            cs.setLong(indexed, (long)((Long)value));
        } else if (value instanceof Boolean) {
            cs.setBoolean(indexed, (boolean)((Boolean)value));
        } else if (value instanceof Timestamp) {
            cs.setTimestamp(indexed, new Timestamp(((java.util.Date)value).getTime()));
        } else if (value instanceof java.util.Date) {
            cs.setDate(indexed, new Date(((java.util.Date)value).getTime()));
        } else if (value instanceof BigDecimal) {
            cs.setBigDecimal(indexed, (BigDecimal)value);
        } else if (value instanceof Blob) {
            cs.setBlob(indexed, (Blob)value);
        } else if (value instanceof Clob) {
            cs.setClob(indexed, (Clob)value);
        } else {
            cs.setObject(indexed, value);
        }
    }

    public static void bindStatementOutput(CallableStatement cs, int indexed, String dataType) throws SQLException {
        if (StringUtil.equals(dataType = dataType.toLowerCase(), "string") || StringUtil.equals(dataType, "char")) {
            cs.registerOutParameter(indexed, 1);
        } else if (StringUtil.equals(dataType, "int") || StringUtil.equals(dataType, "integer")) {
            cs.registerOutParameter(indexed, 4);
        } else if (StringUtil.equals(dataType, "date")) {
            cs.registerOutParameter(indexed, 91);
        } else if (StringUtil.equals(dataType, "timestamp")) {
            cs.registerOutParameter(indexed, 93);
        } else if (StringUtil.equals(dataType, "decimal")) {
            cs.registerOutParameter(indexed, 3);
        } else if (StringUtil.equals(dataType, "float")) {
            cs.registerOutParameter(indexed, 6);
        } else if (StringUtil.equals(dataType, "double")) {
            cs.registerOutParameter(indexed, 8);
        } else if (StringUtil.equals(dataType, "cursor")) {
            cs.registerOutParameter(indexed, -10);
        } else {
            cs.registerOutParameter(indexed, 1);
        }
    }

    public static Object convertType(CallableStatement cs, int indexed, String dataType) throws SQLException {
        dataType = dataType.toLowerCase();
        Object dataValue = null;
        try {
            dataValue = cs.getObject(indexed);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (dataValue == null) {
            return null;
        }
        if (StringUtil.equals(dataType, "cursor")) {
            return ProceUtils.convertResultSetToMapList((ResultSet)dataValue, false);
        }
        return dataValue;
    }

    public static ProceRecord executeProcedure(Connection conn, String sql, Object ... paramArgs) throws SQLException {
        return ProceUtils.execProcedure(conn, sql, new ProcedureCallback(){

            @Override
            public String parse(String sql) {
                String callstr = sql.toLowerCase();
                String nameHead = StringUtil.substringBefore(callstr, "(");
                String paramterBody = StringUtil.substringBetween(callstr, "(", ")");
                StringBuffer callBuffer = new StringBuffer(50);
                if (!StringUtil.contains(sql, "call")) {
                    callBuffer.append("{ call ");
                }
                callBuffer.append(nameHead);
                if (paramterBody != null) {
                    callBuffer.append(" (");
                    Object[] paramterArray = paramterBody.split(",");
                    int i = 0;
                    while (i < paramterArray.length) {
                        String p = paramterArray[i].trim();
                        if (!StringUtil.isEmpty(p)) {
                            if (StringUtil.equals(p, "?")) {
                                this.registerInParameter();
                            } else {
                                String paramname = StringUtil.substringBefore(p, "{");
                                String paramtype = StringUtil.substringBetween(p, "{", "}");
                                paramname = StringUtil.defaultIfEmpty(paramname, "outvar");
                                paramtype = StringUtil.defaultIfEmpty(paramtype, "string");
                                this.registerOutParameter(paramtype, paramname);
                                paramterArray[i] = "?";
                            }
                        }
                        ++i;
                    }
                    callBuffer.append(StringUtil.join(paramterArray, ","));
                    callBuffer.append(")");
                }
                callBuffer.append("}");
                return callBuffer.toString();
            }
        }, paramArgs);
    }

    protected static ProceRecord execProcedure(Connection con, String sql, ProcedureCallback callback, Object ... paramArgs) throws SQLException {
        ProceRecord result = null;
        if (callback == null) {
            throw new RuntimeException("Callback object must not be null");
        }
        result = callback.doInCallback(con, sql, paramArgs);
        return result;
    }
}

