/*
 * Decompiled with CFR 0.152.
 */
package cn.cns.web.utils;

import cn.cns.web.utils.StaticBeans;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class ServletUtils {
    private static final Logger log = LoggerFactory.getLogger(ServletUtils.class);

    public static <T extends Number> T getNumberParam(ServletRequest request, String name) {
        String value = request.getParameter(name);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            try {
                return (T)NumberFormat.getInstance().parse(value);
            }
            catch (ParseException e) {
                log.warn("Request param '{} = {}' isn't a number.", (Object)name, (Object)value);
            }
        }
        return null;
    }

    public static List<MediaType> getMediaTypes(HttpServletRequest request) {
        String accept = request.getHeader("Accept");
        List types = MediaType.parseMediaTypes((String)accept);
        String contentType = request.getContentType();
        if (contentType != null && contentType.trim().length() > 0) {
            types.add(MediaType.parseMediaType((String)request.getContentType()));
        }
        return types;
    }

    public static String getRequestText(HttpServletRequest request) {
        byte[] bytes = new byte[request.getContentLength()];
        try {
            ServletInputStream is = request.getInputStream();
            int length = is.read(bytes);
            return length == 0 ? null : new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T getRequestBody(HttpServletRequest request, Class<T> clz) throws IOException {
        String text = ServletUtils.getRequestText(request);
        if (StringUtils.isNotBlank((CharSequence)text)) {
            Object mapper = (text = text.trim()).startsWith("<") ? StaticBeans.getXmlMapper() : StaticBeans.getObjectMapper();
            return (T)mapper.readValue(text, clz);
        }
        return null;
    }

    public static void responseHtml(ServletResponse response, String html) {
        response.setContentType("text/html");
        ServletUtils.responseText(response, html);
    }

    public static void responseText(ServletResponse response, String text) {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        try (PrintWriter writer = response.getWriter();){
            writer.write(text);
            writer.flush();
        }
        catch (IOException e) {
            log.error("HttpResponse\u8f93\u51fa\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean responseBody(HttpServletRequest request, HttpServletResponse response, Object object) {
        List<MediaType> types = ServletUtils.getMediaTypes(request);
        if (types.size() > 0) {
            for (MediaType type : types) {
                if (type.getSubtype().equalsIgnoreCase("json")) {
                    ServletUtils.responseJson((ServletResponse)response, object);
                    return true;
                }
                if (!type.getSubtype().matches("([A-Za-z]+\\+)?xml|html")) continue;
                ServletUtils.responseXml((ServletResponse)response, object);
                return true;
            }
        }
        return false;
    }

    public static void responseBody(ServletResponse response, Object object, ObjectMapper objectMapper) {
        if (object == null) {
            ServletUtils.responseText(response, "");
        } else {
            try {
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                objectMapper.writeValue((Writer)response.getWriter(), object);
            }
            catch (IOException e) {
                log.error("Object\u8f6c\u5316\u4e3a\u5b57\u7b26\u4e32\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void responseBytes(HttpServletResponse response, byte[] bytes, String name) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + name);
        ServletOutputStream stream = response.getOutputStream();
        stream.write(bytes);
        stream.close();
    }

    public static void responseBodyOrJson(HttpServletRequest request, HttpServletResponse response, Object object) {
        if (!ServletUtils.responseBody(request, response, object)) {
            ServletUtils.responseJson((ServletResponse)response, object);
        }
    }

    public static void responseJson(ServletResponse response, Object object) {
        response.setContentType("application/json");
        ServletUtils.responseBody(response, object, StaticBeans.getObjectMapper());
    }

    public static void responseXml(ServletResponse response, Object object) {
        response.setContentType("application/xml");
        ServletUtils.responseBody(response, object, (ObjectMapper)StaticBeans.getXmlMapper());
    }
}

