/*
 * Decompiled with CFR 0.152.
 */
package cn.cns.web.utils;

import cn.cns.common.utils.StringExtendUtils;
import cn.cns.web.utils.IQueryable;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.LinkedHashMap;
import java.util.Set;

public interface ISortable
extends IQueryable {
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final LinkedHashMap<String, String> SORT = new LinkedHashMap();

    default public void setSorts(LinkedHashMap<String, String> sort) {
        if (SORT.size() > 0) {
            SORT.clear();
        }
        SORT.putAll(sort);
    }

    default public LinkedHashMap<String, String> getSorts() {
        return SORT;
    }

    @Override
    default public <T> QueryWrapper<T> newQueryWrapper(Class<T> clz) {
        QueryWrapper<T> wrapper = IQueryable.super.newQueryWrapper(clz);
        this.fillSorts(wrapper, clz);
        return wrapper;
    }

    default public <T> void fillSorts(QueryWrapper<T> wrapper, Class<T> clz) {
        if (SORT.isEmpty()) {
            return;
        }
        Set<String> columns = this.filterFields(SORT.keySet(), clz, false);
        if (columns.isEmpty()) {
            return;
        }
        for (String key : columns) {
            String value = SORT.get(key);
            String snakeKey = StringExtendUtils.toSnakeCase((String)key);
            if (DESC.equalsIgnoreCase(value)) {
                wrapper.orderByDesc((Object)snakeKey);
                continue;
            }
            wrapper.orderByAsc((Object)snakeKey);
        }
    }
}

