/*
 * Decompiled with CFR 0.152.
 */
package cn.cns.web.utils;

import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;

public class AppContext {
    private static final Logger log = LoggerFactory.getLogger(AppContext.class);
    public static ConfigurableApplicationContext context;

    public AppContext(ConfigurableApplicationContext context) {
        AppContext.context = context;
    }

    public static <T> boolean registBean(Class<T> clz, Object ... constructorArgs) {
        int size = context.getBeansOfType(clz).size();
        if (size > 0) {
            log.warn("Bean \u7c7b\u578b {} \u5df2\u7ecf\u5b58\u5728 {} \u4e2a\uff0c\u6ce8\u518c\u5931\u8d25", (Object)clz.getName(), (Object)size);
            return false;
        }
        String className = clz.getSimpleName();
        String beanName = className.substring(0, 1).toLowerCase() + className.substring(1);
        return AppContext.registBean(clz, beanName, constructorArgs);
    }

    public static <T> boolean registBean(Class<T> clz, String beanName, Object ... constructorArgs) {
        if (context.containsBean(beanName)) {
            log.warn("\u540d\u5b57\u4e3a {} \u7684 Bean \u5df2\u7ecf\u5b58\u5728\uff0c\u6ce8\u518c\u5931\u8d25", (Object)beanName);
            return false;
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clz);
        Arrays.stream(constructorArgs).forEach(arg_0 -> ((BeanDefinitionBuilder)beanDefinitionBuilder).addConstructorArgValue(arg_0));
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)context.getBeanFactory();
        beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return true;
    }

    public static Object getBean(String beanName) {
        return context.getBean(beanName);
    }

    public static <T> T getBean(String beanName, Class<T> clazz) {
        return (T)context.getBean(beanName, clazz);
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            Collection beans = context.getBeansOfType(clazz).values();
            return (T)(beans.isEmpty() ? null : beans.stream().filter(t -> t.getClass().getName().equals(clazz.getName())).findFirst().orElse(beans.iterator().next()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean containsBean(String beanName) {
        return context.containsBean(beanName);
    }

    public static boolean isSingleton(String beanName) {
        return context.isSingleton(beanName);
    }

    public static Class<?> getType(String beanName) {
        return context.getType(beanName);
    }
}

