/*
 * Decompiled with CFR 0.152.
 */
package cn.cns.web.servlet.convert;

import cn.cns.common.dto.IDictionary;
import java.util.Arrays;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.validation.BindException;

public class DictionaryConverter<T extends IDictionary<?>>
implements Converter<String, T> {
    private final Class<T> clz;
    private final boolean enable;

    public DictionaryConverter(Class<T> clz) {
        this.clz = clz;
        this.enable = clz.isEnum();
    }

    public T convert(@NonNull String s) {
        if (!this.enable) {
            return null;
        }
        return (T)Arrays.stream((IDictionary[])this.clz.getEnumConstants()).filter(i -> i.getValue().toString().equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new BindException((Object)s, this.clz.getName()));
    }
}

