package cn.cns.web.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.List;

/**
 * 静态 Bean 引用类
 *
 * @author dhc
 */
public class StaticBeans {
    private static ObjectMapper objectMapper;
    private static XmlMapper xmlMapper;
    private static RestTemplate restTemplate;

    public static void configObjectMapperDefault(ObjectMapper objectMapper) {
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
        objectMapper.registerModule(new JavaTimeModule());
    }

    public static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            synchronized (StaticBeans.class) {
                if (objectMapper == null) {
                    objectMapper = AppContext.getBean(ObjectMapper.class);
                }
                if (objectMapper == null) {
                    objectMapper = new ObjectMapper();
                    configObjectMapperDefault(objectMapper);
                }
            }
        }
        return objectMapper;
    }

    public static XmlMapper getXmlMapper() {
        if (xmlMapper == null) {
            synchronized (StaticBeans.class) {
                if (xmlMapper == null) {
                    xmlMapper = AppContext.getBean(XmlMapper.class);
                }
                if (xmlMapper == null) {
                    xmlMapper = new XmlMapper();
                    configObjectMapperDefault(xmlMapper);
                }
            }
        }
        return xmlMapper;
    }

    public static RestTemplate getRestTemplate() {
        if (restTemplate == null) {
            restTemplate = AppContext.getBean(RestTemplate.class);
        }
        if (restTemplate == null) {
            restTemplate = new RestTemplate();
            restTemplate.getMessageConverters().stream()
                    .filter(c -> c instanceof MappingJackson2HttpMessageConverter)
                    .map(c -> (MappingJackson2HttpMessageConverter) c).forEach(c -> {
                List<MediaType> supportTypes = new ArrayList<>();
                supportTypes.add(MediaType.APPLICATION_JSON);
                supportTypes.add(new MediaType("application", "*+json"));
                supportTypes.add(MediaType.TEXT_PLAIN);
                supportTypes.add(MediaType.TEXT_HTML);
                c.setSupportedMediaTypes(supportTypes);
            });
        }
        return restTemplate;
    }
}
