package cn.cns.web.utils;

import cn.cns.common.utils.StringExtendUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

import java.util.LinkedHashMap;
import java.util.Set;

public interface ISortable extends IQueryable {
    String ASC = "ASC";
    String DESC = "DESC";
    LinkedHashMap<String, String> SORT = new LinkedHashMap<>();

    default void setSorts(LinkedHashMap<String, String> sort) {
        if (SORT.size() > 0) {
            SORT.clear();
        }
        SORT.putAll(sort);
    }

    default LinkedHashMap<String, String> getSorts() {
        return SORT;
    }

    @Override
    default <T> QueryWrapper<T> newQueryWrapper(Class<T> clz) {
        QueryWrapper<T> wrapper = IQueryable.super.newQueryWrapper(clz);
        this.fillSorts(wrapper, clz);
        return wrapper;
    }

    default <T> void fillSorts(QueryWrapper<T> wrapper, Class<T> clz) {
        if (SORT.isEmpty()) {
            return;
        }

        Set<String> columns = this.filterFields(SORT.keySet(), clz, false);
        if (columns.isEmpty()) {
            return;
        }

        for (String key : columns) {
            String value = SORT.get(key);
            String snakeKey = StringExtendUtils.toSnakeCase(key);
            if (DESC.equalsIgnoreCase(value)) {
                wrapper.orderByDesc(snakeKey);
            } else {
                wrapper.orderByAsc(snakeKey);
            }
        }
    }
}
