/*
 * Decompiled with CFR 0.152.
 */
package cn.cns.web.utils;

import cn.cns.web.utils.AppContext;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.ArrayList;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class StaticBeans {
    private static ObjectMapper objectMapper;
    private static XmlMapper xmlMapper;
    private static RestTemplate restTemplate;

    public static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = AppContext.getBean(ObjectMapper.class);
        }
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        return objectMapper;
    }

    public static XmlMapper getXmlMapper() {
        if (xmlMapper == null) {
            xmlMapper = AppContext.getBean(XmlMapper.class);
        }
        if (xmlMapper == null) {
            xmlMapper = new XmlMapper();
            xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        return xmlMapper;
    }

    public static RestTemplate getRestTemplate() {
        if (restTemplate == null) {
            restTemplate = AppContext.getBean(RestTemplate.class);
        }
        if (restTemplate == null) {
            restTemplate = new RestTemplate();
            for (HttpMessageConverter converter : restTemplate.getMessageConverters()) {
                if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
                MappingJackson2HttpMessageConverter mjhmc = (MappingJackson2HttpMessageConverter)converter;
                ArrayList<MediaType> supportTypes = new ArrayList<MediaType>();
                supportTypes.add(MediaType.APPLICATION_JSON);
                supportTypes.add(new MediaType("application", "*+json"));
                supportTypes.add(MediaType.TEXT_PLAIN);
                supportTypes.add(MediaType.TEXT_HTML);
                mjhmc.setSupportedMediaTypes(supportTypes);
            }
        }
        return restTemplate;
    }
}

