/*
 * Decompiled with CFR 0.152.
 */
package cn.cns.common.utils;

import java.util.List;
import java.util.Map;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.DefaultMapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public class BeanMapper {
    public static final MapperFactory MAPPER_FACTORY = new DefaultMapperFactory.Builder().build();
    private static final MapperFacade DEFAULT_MAPPER = MAPPER_FACTORY.getMapperFacade();

    public static <S, D> D map(S source, Class<D> distClass) {
        return BeanMapper.map(source, distClass, DEFAULT_MAPPER);
    }

    public static <S, D> D map(S source, Class<D> distClass, MapperFacade mapper) {
        return (D)mapper.map(source, distClass);
    }

    private static <S, D> MapperFacade buildClassMapperFacade(Class<S> sourceClass, Class<D> distClass, Map<String, String> fieldMap) {
        DefaultMapperFactory factory = new DefaultMapperFactory.Builder().build();
        ClassMapBuilder classMapBuilder = factory.classMap(sourceClass, distClass);
        fieldMap.keySet().forEach(k -> classMapBuilder.field(k, (String)fieldMap.get(k)));
        classMapBuilder.byDefault(new DefaultFieldMapper[0]).register();
        return factory.getMapperFacade();
    }

    public static <S, D> D map(S source, Class<D> distClass, Map<String, String> fieldMap) {
        return (D)BeanMapper.buildClassMapperFacade(source.getClass(), distClass, fieldMap).map(source, distClass);
    }

    public static <S, D> List<D> mapList(Iterable<S> sourceList, Class<S> sourceClass, Class<D> distClass, Map<String, String> fieldMap) {
        return BeanMapper.buildClassMapperFacade(sourceClass, distClass, fieldMap).mapAsList(sourceList, TypeFactory.valueOf(sourceClass), TypeFactory.valueOf(distClass));
    }

    public static <S, D> D map(S source, Type<S> sourceType, Type<D> distType) {
        return (D)DEFAULT_MAPPER.map(source, sourceType, distType);
    }

    public static <S, D> List<D> mapList(Iterable<S> sourceList, Class<S> sourceClass, Class<D> distClass) {
        return DEFAULT_MAPPER.mapAsList(sourceList, TypeFactory.valueOf(sourceClass), TypeFactory.valueOf(distClass));
    }

    public static <S, D> List<D> mapList(Iterable<S> sourceList, Type<S> sourceType, Type<D> destinationType) {
        return DEFAULT_MAPPER.mapAsList(sourceList, sourceType, destinationType);
    }

    public static <S, D> D[] mapArray(D[] destination, S[] source, Class<D> destinationClass) {
        return DEFAULT_MAPPER.mapAsArray((Object[])destination, (Object[])source, destinationClass);
    }

    public static <S, D> D[] mapArray(D[] destination, S[] source, Type<S> sourceType, Type<D> destinationType) {
        return DEFAULT_MAPPER.mapAsArray((Object[])destination, (Object[])source, sourceType, destinationType);
    }
}

