/*
 * Decompiled with CFR 0.152.
 */
package cn.cns.common.bean;

import cn.cns.common.bean.ResultMessage;
import java.io.Serializable;

public class Result<T>
implements Serializable {
    private int code = 1;
    private String message = "SUCCESS";
    private T data;

    public Result() {
    }

    public Result(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public Result(ResultMessage message) {
        this.code = message.getCode();
        this.message = message.getMessage();
    }

    public Result(T data) {
        this.data = data;
    }

    public Result(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> Result<T> success() {
        return new Result<T>();
    }

    public static <T> Result<T> success(T t) {
        return new Result<T>(t);
    }

    public static <T> Result<T> error(int code, String message, Object ... msgArgs) {
        String msg = message != null && message.length() > 1 && msgArgs != null && msgArgs.length > 0 ? String.format(message, msgArgs) : message;
        return new Result<T>(code, message);
    }

    public static <T> Result<T> error(ResultMessage message, Object ... msgArgs) {
        String msg = msgArgs != null && msgArgs.length > 0 ? String.format(message.getMessage(), msgArgs) : message.getMessage();
        return new Result<T>(message.getCode(), msg);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

