package cn.cns.common.error;

import cn.cns.common.bean.Result;
import cn.cns.common.bean.ResultMessage;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author dhc
 * 2019-11-21 00:14
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class BizException extends RuntimeException {
    private int code;

    public BizException(int code, String message) {
        super(message);
        this.code = code;
    }

    public BizException(ResultMessage message) {
        super(message.getMessage());
        this.code = message.getCode();
    }

    public Result toResult() {
        return Result.error(this.code, this.getMessage());
    }
}
