package cn.cnaworld.framework.infrastructure.utils;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.yaml.snakeyaml.Yaml;

import javax.annotation.PostConstruct;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 获取系统配置及资源信息
 * @author Lucifer
 * @date 2023/3/9
 * @since 1.0.0
 */
@Setter
@Slf4j
@Deprecated
public class LogSysConfig {

	@Autowired(required = false)
    private Environment environmentProperties;

	private static Environment environment;

    @PostConstruct
    public void init() {
		environment=environmentProperties;
    }

    private static Map<String,LinkedHashMap<String, Object>> yamlCache=new HashMap<>();

	/**
	 * 获取上下文配置中的属性值
	 * @param configFullName 完整配置名称 例如：spring.application.name
	 * @return 属性值
	 */
	public static <T> T getApplicationConfigByFullName(String configFullName){
		T property = null;
		if (environment != null) {
			property = (T) environment.getProperty(configFullName);
		}
		if(ObjectUtils.isEmpty(property)){
			property = (T) getApplicationConfig(configFullName,false);
		}
		return property;
	}

	/**
	 * 获取上下文配置中的属性值 通过解析yml的方式，建议使用getEnvironmentValue
	 * @param environmentName 属性值名称
	 * @return 属性值
	 */
	private static <T> T getApplicationConfig(String environmentName , boolean recursion){
		LinkedHashMap<String, Object> sourceMap = null;
		sourceMap = getSourceMap("application.yml");
		if (ObjectUtils.isEmpty(sourceMap)) {
			sourceMap = getSourceMap("application.yaml");
		}
		T value = null;
		if(ObjectUtils.isNotEmpty(sourceMap)){
			value = (T) getString(sourceMap, environmentName);
			if (ObjectUtils.isEmpty(value) && !"spring.profiles.active".equals(environmentName)) {
				sourceMap=null;
				String environmentValue = getApplicationConfig("spring.profiles.active",true);
				if (StringUtils.isNotBlank(environmentValue)) {
					sourceMap = getSourceMap("application-"+environmentValue+".yml");
					if (ObjectUtils.isEmpty(sourceMap)) {
						sourceMap = getSourceMap("application-"+environmentValue+".yaml");
					}
				}
				if(ObjectUtils.isNotEmpty(sourceMap)){
					value = (T) getString(sourceMap, environmentName);
				}
			}
		}

		if (!recursion) {
			log.trace("配置文件中不存在此属性:{}",environmentName);
			//Assert.notNull(value, "配置文件中不存在此属性:"+environmentName);
		}
		return value;
	}

	/**
	 * 根据yaml文件名称获取配置map
	 * @author Lucifer
	 * @date 2023/3/9
	 * @since 1.0.0
	 * @param ymlName yml文件名称
	 * @return LinkedHashMap
	 */
	private static LinkedHashMap<String, Object> getSourceMap(String ymlName) {
		LinkedHashMap<String, Object> yamlMap = yamlCache.get(ymlName);
		if(ObjectUtils.isNotEmpty(yamlMap)) {
			return yamlMap;
		}

		InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream(ymlName);
		if (in != null) {
			Yaml yaml = new Yaml();
			yamlMap = yaml.load(in);
			yamlCache.put(ymlName,yamlMap);
		}
		return yamlMap;
	}

	/**
	 * 配置中遍历出需要的配置属性
	 * @author Lucifer
	 * @date 2023/3/9
	 * @since 1.0.0
	 * @param sourceMap 配置源
	 * @param key 目标属性
	 * @return String
	 */
	@SuppressWarnings("unchecked")
	private static Object getString(LinkedHashMap<String, Object> sourceMap, String key) {
		LinkedHashMap<String, Object> map = (LinkedHashMap<String, Object>) sourceMap.clone();
		String[] keys = key.split("[.]");
		int length = keys.length;
		Object resultValue = null;
		for (int i = 0; i < length; i++) {
			Object value = map.get(keys[i]);
			if(value==null){
				return null;
			}
			if (i < length - 1) {
				map = ((LinkedHashMap<String, Object>) value);
			}else {
				resultValue = value;
			}
		}
		return resultValue;
	}

}

