/*
 * Decompiled with CFR 0.152.
 */
package cn.cnaworld.framework.infrastructure.utils;

import cn.cnaworld.framework.infrastructure.properties.CnaworldLogProperties;
import cn.cnaworld.framework.infrastructure.statics.enums.LogLevel;
import cn.cnaworld.framework.infrastructure.utils.LogSysConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CnaLogUtil {
    private static final Logger log = LoggerFactory.getLogger(CnaLogUtil.class);
    @Autowired
    private CnaworldLogProperties cnaworldLog;
    private static CnaworldLogProperties cnaworldLogProperties;
    private static Map<String, LogLevel> localCachedMap;

    @PostConstruct
    private void init() {
        cnaworldLogProperties = this.cnaworldLog;
        this.initCache();
    }

    private void initCache() {
        CnaLogUtil.initLogProperties();
    }

    private static void initLogProperties() {
        if (cnaworldLogProperties != null && ObjectUtils.isEmpty(localCachedMap)) {
            List<CnaworldLogProperties.LogProperties> logProperties = cnaworldLogProperties.getLogProperties();
            CnaLogUtil.cacheMap(logProperties);
        } else if (ObjectUtils.isEmpty(localCachedMap)) {
            try {
                List logProperties = (List)LogSysConfig.getApplicationConfigByFullName("cnaworld.log.log-properties");
                if (logProperties != null) {
                    logProperties = (List)JSON.parseObject((String)JSON.toJSONString((Object)logProperties), (TypeReference)new TypeReference<List<CnaworldLogProperties.LogProperties>>(){}, (Feature[])new Feature[0]);
                    CnaLogUtil.cacheMap(logProperties);
                }
            }
            catch (Exception e) {
                log.error("cnaworld log \u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static void cacheMap(List<CnaworldLogProperties.LogProperties> logProperties) {
        localCachedMap = new TreeMap<String, LogLevel>();
        if (ObjectUtils.isNotEmpty(logProperties)) {
            for (CnaworldLogProperties.LogProperties logProperty : logProperties) {
                LogLevel logLevel = logProperty.getLogLevel();
                if (logLevel == null) {
                    logLevel = LogLevel.DEBUG;
                }
                localCachedMap.put(logProperty.getPathName(), logLevel);
                log.info("cnaworld log \u5305\u8def\u5f84:{} \u65e5\u5fd7\u7b49\u7ea7\u8c03\u6574\u4e3a : {} ", (Object)logProperty.getPathName(), (Object)logLevel);
            }
        }
    }

    public static void trace(Logger log, String format, Object ... arguments) {
        CnaLogUtil.log(log, LogLevel.TRACE, format, arguments);
    }

    public static void debug(Logger log, String format, Object ... arguments) {
        CnaLogUtil.log(log, LogLevel.DEBUG, format, arguments);
    }

    public static void info(Logger log, String format, Object ... arguments) {
        CnaLogUtil.log(log, LogLevel.INFO, format, arguments);
    }

    public static void warn(Logger log, String format, Object ... arguments) {
        CnaLogUtil.log(log, LogLevel.WARN, format, arguments);
    }

    public static void error(Logger log, String format, Object ... arguments) {
        CnaLogUtil.log(log, LogLevel.ERROR, format, arguments);
    }

    private static void log(Logger log, LogLevel defaultLogLeave, String format, Object ... arguments) {
        LogLevel logLeave = null;
        if (ObjectUtils.isEmpty(localCachedMap) && cnaworldLogProperties == null) {
            CnaLogUtil.initLogProperties();
        }
        boolean updateFlag = false;
        if (ObjectUtils.isNotEmpty(localCachedMap)) {
            for (Map.Entry<String, LogLevel> entry : localCachedMap.entrySet()) {
                if (!log.getName().startsWith(entry.getKey())) continue;
                logLeave = localCachedMap.get(entry.getKey());
                updateFlag = true;
            }
        }
        if (!updateFlag) {
            logLeave = defaultLogLeave;
        }
        if (logLeave == null) {
            logLeave = LogLevel.DEBUG;
        }
        CnaLogUtil.printLog(log, logLeave, format, arguments);
    }

    private static void printLog(Logger log, LogLevel logLeave, String format, Object ... arguments) {
        switch (logLeave) {
            case TRACE: {
                if (!log.isTraceEnabled()) break;
                log.trace(format, arguments);
                break;
            }
            case DEBUG: {
                if (!log.isDebugEnabled()) break;
                log.debug(format, arguments);
                break;
            }
            case INFO: {
                if (!log.isInfoEnabled()) break;
                log.info(format, arguments);
                break;
            }
            case WARN: {
                if (!log.isWarnEnabled()) break;
                log.warn(format, arguments);
                break;
            }
            case ERROR: {
                if (!log.isErrorEnabled()) break;
                log.error(format, arguments);
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug(format, arguments);
            }
        }
    }

    static {
        localCachedMap = null;
    }
}

