/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudself.script;

import cn.cloudself.script.CommonFunctionsForScript;
import cn.cloudself.script.util.LogFactory;
import cn.cloudself.script.util.Ref;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScript {
    public static String JavaFunctionName = "Jv_FN";
    public static boolean doesRuntimeCompilationSupported = false;
    private static final ThreadLocal<Boolean> disableLog = ThreadLocal.withInitial(() -> false);
    private static final LogFactory.Log log = LogFactory.getLog(CommonFunctionsForScript.class);
    private final Context.Builder builder = Context.newBuilder((String[])new String[0]).allowAllAccess(true).option("js.foreign-object-prototype", "true").option("engine.WarnInterpreterOnly", doesRuntimeCompilationSupported + "");
    private final Object functions;
    private final String functionsHelper;
    private static final BigInteger maxLongValueBigIntegerView = new BigInteger(String.valueOf(Long.MAX_VALUE));
    private static final BigDecimal maxLongValueBigDecimalView = new BigDecimal(Long.MAX_VALUE);

    public static void disableLogThreadLocal(Boolean disable) {
        disableLog.set(disable);
    }

    public JavaScript(Object functions) {
        this.functions = functions;
        this.functionsHelper = Arrays.stream(functions.getClass().getDeclaredMethods()).map(jf -> "const " + jf.getName() + "=s=>" + JavaFunctionName + "." + jf.getName() + "(s);").collect(Collectors.joining());
    }

    private static Object toJsObject(Object value) {
        BigInteger bigInteger;
        if (value instanceof Ref) {
            value = ((Ref)value).getValue();
        } else if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            if (bigDecimal.compareTo(maxLongValueBigDecimalView) < 0) {
                value = bigDecimal.doubleValue();
            }
        } else if (value instanceof BigInteger && (bigInteger = (BigInteger)value).compareTo(maxLongValueBigIntegerView) < 0) {
            value = bigInteger.longValue();
        }
        return value;
    }

    private static <T> T transResult(T result, @NotNull Function<Value, Object> itemTranslator, @NotNull Function<Value, Object> finalTranslator) {
        if (result instanceof List) {
            return (T)((List)result).stream().map(it -> JavaScript.transResult(it, itemTranslator, finalTranslator)).collect(Collectors.toList());
        }
        if (result instanceof Map) {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>((Map)result);
            hashMap.replaceAll((k, v) -> JavaScript.transResult(v, itemTranslator, finalTranslator));
            return (T)hashMap;
        }
        if (result instanceof Value) {
            Value value = (Value)result;
            Object tempResult = itemTranslator.apply(value);
            if (tempResult instanceof Value) {
                Value step1value = (Value)tempResult;
                tempResult = step1value.hasArrayElements() ? step1value.as((TypeLiteral)new TypeLiteral<List<Value>>(){}) : (step1value.hasHashEntries() || step1value.hasMembers() ? step1value.as((TypeLiteral)new TypeLiteral<Map<String, Value>>(){}) : finalTranslator.apply(step1value));
            }
            return (T)JavaScript.transResult(tempResult, itemTranslator, finalTranslator);
        }
        return result;
    }

    private static Object finalTranslator(Value value) {
        return value.as(Object.class);
    }

    private static Object baseTranslator(Value value) {
        if (value.isNull()) {
            return null;
        }
        if (value.isHostObject()) {
            return value.asHostObject();
        }
        if (value.isString()) {
            return value.asString();
        }
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isNumber()) {
            return value.as(Object.class);
        }
        return value;
    }

    private static Object dateTimeTranslator(Value value) {
        LocalDate date = null;
        LocalTime time = null;
        if (value.isDate()) {
            date = value.asDate();
        }
        if (value.isTime()) {
            time = value.asTime();
        }
        if (date != null) {
            if (time != null) {
                return LocalDateTime.of(date, time);
            }
            return date;
        }
        if (time != null) {
            return time;
        }
        return value;
    }

    public Prepared of(String script) {
        return this.prepare(script, false);
    }

    public Prepared compile(String script) {
        return this.prepare(script, true);
    }

    public PreparedBatch ofBatch(@NotNull String resultExpression) {
        return new PreparedBatch(null, null, resultExpression);
    }

    public PreparedBatch ofBatch(@Nullable String sharedScript, @NotNull String resultExpression) {
        return new PreparedBatch(sharedScript, null, resultExpression);
    }

    public PreparedBatch ofBatch(@Nullable String sharedScript, @NotNull String calcStatement, @NotNull String resultExpression) {
        return new PreparedBatch(sharedScript, calcStatement, resultExpression);
    }

    private Prepared prepare(String script, Boolean cache) {
        StringBuilder finalScriptBuilder = new StringBuilder();
        finalScriptBuilder.append(this.functionsHelper);
        if (script.startsWith("{")) {
            finalScriptBuilder.append('(');
            finalScriptBuilder.append(script);
            finalScriptBuilder.append(')');
        } else {
            finalScriptBuilder.append(script);
        }
        String finalScript = finalScriptBuilder.toString();
        Source source = Source.newBuilder((String)"js", (CharSequence)finalScript, null).cached(cache.booleanValue()).buildLiteral();
        return new Prepared(source);
    }

    public class Prepared {
        private final Source source;
        private final Stack<Function<Value, Object>> translators = new Stack();

        private Prepared(Source source) {
            this.source = source;
            this.translators.add(x$0 -> JavaScript.baseTranslator(x$0));
            this.translators.add(x$0 -> JavaScript.dateTimeTranslator(x$0));
        }

        public Prepared addValueTranslator(Function<Value, Object> itemTranslator) {
            this.translators.add(itemTranslator);
            return this;
        }

        public Map<String, Object> evalAsMap() {
            return this.evalAsMap(Collections.emptyIterator());
        }

        public Map<String, Object> evalAsMap(Map<String, ?> vars) {
            return this.evalAsMap(vars.entrySet().iterator());
        }

        public Map<String, Object> evalAsMap(Iterator<? extends Map.Entry<String, ?>> vars) {
            return this.eval(vars, v -> (Map)v.as((TypeLiteral)new TypeLiteral<Map<String, Value>>(){}), true);
        }

        public List<Object> evalAsList() {
            return this.evalAsList(Collections.emptyIterator());
        }

        public List<Object> evalAsList(Map<String, ?> vars) {
            return this.evalAsList(vars.entrySet().iterator());
        }

        public List<Object> evalAsList(Iterator<? extends Map.Entry<String, ?>> vars) {
            return this.eval(vars, v -> (List)v.as((TypeLiteral)new TypeLiteral<List<Value>>(){}), true);
        }

        public <T> T eval(Map<String, ?> vars, Class<T> resultType) {
            return this.eval(vars.entrySet().iterator(), resultType);
        }

        public <T> T eval(Iterator<? extends Map.Entry<String, ?>> vars, Class<T> resultType) {
            return (T)this.eval(vars, v -> v.as(resultType), false);
        }

        public <T> T eval(Map<String, ?> vars, TypeLiteral<T> resultType) {
            return this.eval(vars.entrySet().iterator(), resultType);
        }

        public <T> T eval(Iterator<? extends Map.Entry<String, ?>> vars, TypeLiteral<T> resultType) {
            return (T)this.eval(vars, v -> v.as(resultType), false);
        }

        <T> T eval(Iterator<? extends Map.Entry<String, ?>> vars, Function<Value, T> resultHandler, boolean translateValueToObject) {
            try (Context context = JavaScript.this.builder.build();){
                Boolean d;
                Value bindings = context.getBindings("js");
                bindings.putMember(JavaFunctionName, JavaScript.this.functions);
                if (vars != null) {
                    this.toJsObject(vars, bindings);
                }
                if (!(d = (Boolean)disableLog.get()).booleanValue()) {
                    log.info(this.source.getCharacters());
                }
                Value step0result = context.eval(this.source);
                T step1result = resultHandler.apply(step0result);
                Object result = JavaScript.transResult(step1result, v -> {
                    if (!translateValueToObject) {
                        return v;
                    }
                    for (Function function : this.translators) {
                        Object r = function.apply(v);
                        if (!(r instanceof Value)) {
                            return r;
                        }
                        v = (Value)r;
                    }
                    return v;
                }, x$0 -> JavaScript.finalTranslator(x$0));
                if (!d.booleanValue()) {
                    log.info("eval result: " + result);
                }
                Object object = result;
                return (T)object;
            }
        }

        private void toJsObject(@NotNull Iterator<? extends Map.Entry<String, ?>> vars, Value bindings) {
            while (vars.hasNext()) {
                Map.Entry<String, ?> entry = vars.next();
                String key = entry.getKey();
                Object value = entry.getValue();
                value = JavaScript.toJsObject(value);
                bindings.putMember(key, value);
            }
        }
    }

    public class PreparedBatch {
        private final String sharedScript;
        private final String calcStatement;
        private final String resultExpression;

        private PreparedBatch(String sharedScript, String calcStatement, String resultExpression) {
            this.sharedScript = sharedScript;
            this.calcStatement = calcStatement;
            this.resultExpression = resultExpression;
        }

        public <T> List<T> evalBatch(Iterable<String> varNames, Iterable<? extends Iterator<? extends Map.Entry<String, ?>>> varsBatch) {
            return this.evalBatch(varNames, varsBatch, null);
        }

        public <T> List<T> evalBatch(Iterable<String> varNames, Iterable<? extends Iterator<? extends Map.Entry<String, ?>>> varsBatch, TypeLiteral<T> resultType) {
            StringBuilder finalScriptBuilder = new StringBuilder();
            finalScriptBuilder.append(JavaScript.this.functionsHelper);
            finalScriptBuilder.append("\nconst _var_names = [...varNames];\n");
            if (this.sharedScript != null) {
                String trimmedSharedScript = this.sharedScript.trim();
                finalScriptBuilder.append(trimmedSharedScript);
                if (!trimmedSharedScript.endsWith(";")) {
                    finalScriptBuilder.append(';');
                }
                finalScriptBuilder.append('\n');
            }
            finalScriptBuilder.append("function _calc(");
            for (String varName : varNames) {
                finalScriptBuilder.append(varName);
                finalScriptBuilder.append(", ");
            }
            finalScriptBuilder.append(") { ");
            if (this.calcStatement != null) {
                String trimmedCalcStatement = this.calcStatement.trim();
                finalScriptBuilder.append(trimmedCalcStatement);
                if (!trimmedCalcStatement.endsWith(";")) {
                    finalScriptBuilder.append(';');
                }
                finalScriptBuilder.append('\n');
            }
            finalScriptBuilder.append("\nreturn ");
            finalScriptBuilder.append(this.resultExpression.trim());
            finalScriptBuilder.append(";\n}\n");
            finalScriptBuilder.append("const _results = [];\n");
            finalScriptBuilder.append("for (const vars of varsBatch) { _results.push(_calc.apply(null, _var_names.map(n => vars[n]))) }\n");
            finalScriptBuilder.append("_results;");
            String finalScript = finalScriptBuilder.toString();
            HashMap<String, Iterable<String>> vars = new HashMap<String, Iterable<String>>();
            vars.put("varNames", varNames);
            List varsBatchConverted = StreamSupport.stream(varsBatch.spliterator(), false).map(entries -> {
                HashMap<String, Object> var = new HashMap<String, Object>();
                while (entries.hasNext()) {
                    Map.Entry entry = (Map.Entry)entries.next();
                    var.put((String)entry.getKey(), JavaScript.toJsObject(entry.getValue()));
                }
                return var;
            }).collect(Collectors.toList());
            vars.put("varsBatch", varsBatchConverted);
            Source source = Source.create((String)"js", (CharSequence)finalScript);
            List<Object> results = new Prepared(source).addValueTranslator(value -> value.as((TypeLiteral)new TypeLiteral<List<Value>>(){})).evalAsList(vars.entrySet().iterator());
            return results;
        }
    }
}

