/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudself.script.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class BeanHelper {
    private final Set<String> shouldIgnoreFields = new HashSet<String>(){
        {
            this.add("serialVersionUID");
        }
    };

    private BeanHelper() {
    }

    public static BeanHelper createDefault() {
        return new BeanHelper();
    }

    public Map<String, Object> toMapDeep(Object bean) {
        Class<?> clazz;
        if (bean == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Class<?> classOrSuperClass = clazz = bean.getClass(); classOrSuperClass != null; classOrSuperClass = classOrSuperClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = classOrSuperClass.getDeclaredFields()) {
                Method getter;
                Object value;
                String key = field.getName();
                if (this.shouldIgnoreFields.contains(key)) continue;
                if (BeanHelper.canAccess(field, bean).booleanValue()) {
                    try {
                        value = field.get(bean);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                String getterMethodName = "get" + Character.toUpperCase(key.charAt(0)) + key.substring(1);
                try {
                    getter = clazz.getDeclaredMethod(getterMethodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    try {
                        getter = clazz.getMethod(getterMethodName, new Class[0]);
                    }
                    catch (NoSuchMethodException e2) {
                        throw new RuntimeException("\u65e0\u6cd5\u8bbf\u95ee\u79c1\u6709\u4e14\u65e0getter\u7684\u5c5e\u6027 " + key);
                    }
                }
                try {
                    value = getter.invoke(bean, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                map.put(key, this.trans(value));
            }
        }
        return map;
    }

    private Object trans(Object value) {
        if (value == null || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal || value instanceof BigInteger || value instanceof Boolean || value instanceof String || value instanceof Date || value instanceof LocalDate || value instanceof LocalTime || value instanceof LocalDateTime || value instanceof Duration) {
            return value;
        }
        if (value instanceof Iterable) {
            return StreamSupport.stream(((Iterable)value).spliterator(), false).map(this::trans).collect(Collectors.toList());
        }
        if (value instanceof Object[]) {
            return Arrays.stream((Object[])value).map(this::trans).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                map.put(k + "", this.trans(v));
            }
            return map;
        }
        return this.toMapDeep(value);
    }

    private static Boolean canAccess(Field field, Object obj) {
        try {
            field.get(obj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }
}

