/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudself.script;

import cn.cloudself.script.CommonFunctionsForScript;
import cn.cloudself.script.util.LogFactory;
import cn.cloudself.script.util.Ref;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.jetbrains.annotations.NotNull;

public class JavaScript {
    public static String JavaFunctionName = "Jv_FN";
    public static boolean doesRuntimeCompilationSupported = false;
    private static final ThreadLocal<Boolean> disableLog = ThreadLocal.withInitial(() -> false);
    private static final LogFactory.Log log = LogFactory.getLog(CommonFunctionsForScript.class);
    private final Context.Builder builder = Context.newBuilder((String[])new String[0]).allowAllAccess(true).option("engine.WarnInterpreterOnly", doesRuntimeCompilationSupported + "");
    private final Object functions;
    private final String functionsHelper;
    private static final BigInteger maxLongValueBigIntegerView = new BigInteger(String.valueOf(Long.MAX_VALUE));
    private static final BigDecimal maxLongValueBigDecimalView = new BigDecimal(Long.MAX_VALUE);

    public static void disableLogThreadLocal(Boolean disable) {
        disableLog.set(disable);
    }

    public JavaScript(Object functions) {
        this.functions = functions;
        this.functionsHelper = Arrays.stream(functions.getClass().getDeclaredMethods()).map(jf -> "const " + jf.getName() + "=s=>" + JavaFunctionName + "." + jf.getName() + "(s);").collect(Collectors.joining());
    }

    public Prepared of(String script) {
        return this.prepare(script, false);
    }

    public Prepared compile(String script) {
        return this.prepare(script, true);
    }

    private Prepared prepare(String script, Boolean cache) {
        StringBuilder finalScriptBuilder = new StringBuilder();
        finalScriptBuilder.append(this.functionsHelper);
        if (script.startsWith("{")) {
            finalScriptBuilder.append('(');
            finalScriptBuilder.append(script);
            finalScriptBuilder.append(')');
        } else {
            finalScriptBuilder.append(script);
        }
        String finalScript = finalScriptBuilder.toString();
        Source source = Source.newBuilder((String)"js", (CharSequence)finalScript, null).cached(cache.booleanValue()).buildLiteral();
        return new Prepared(source);
    }

    public class Prepared {
        private final Source source;

        private Prepared(Source source) {
            this.source = source;
        }

        public Object eval(Map<String, ?> vars) {
            return this.eval(vars.entrySet().iterator(), this::toJavaObject);
        }

        public Object eval() {
            return this.eval(Collections.emptyIterator(), this::toJavaObject);
        }

        public <T> T eval(Map<String, ?> vars, Class<T> resultType) {
            return (T)this.eval(vars.entrySet().iterator(), (Value v) -> v.as(resultType));
        }

        public <T> T eval(Map<String, ?> vars, TypeLiteral<T> resultType) {
            return (T)this.eval(vars.entrySet().iterator(), (Value v) -> v.as(resultType));
        }

        public <T> T eval(Iterator<? extends Map.Entry<String, ?>> vars, TypeLiteral<T> resultType) {
            return (T)this.eval(vars, (Value v) -> v.as(resultType));
        }

        private <T> T eval(Iterator<? extends Map.Entry<String, ?>> vars, Function<Value, T> resultHandler) {
            try (Context context = JavaScript.this.builder.build();){
                Object result;
                Boolean d;
                Value bindings = context.getBindings("js");
                bindings.putMember(JavaFunctionName, JavaScript.this.functions);
                if (vars != null) {
                    this.toJsObject(vars, bindings);
                }
                if (!(d = (Boolean)disableLog.get()).booleanValue()) {
                    log.info(this.source.getCharacters());
                }
                if ((result = resultHandler.apply(context.eval(this.source))) instanceof List) {
                    result = new ArrayList((List)result);
                }
                if (result instanceof Map) {
                    result = new HashMap((Map)result);
                }
                if (!d.booleanValue()) {
                    log.info("eval result: " + result);
                }
                Object object = result;
                return object;
            }
        }

        private void toJsObject(@NotNull Iterator<? extends Map.Entry<String, ?>> vars, Value bindings) {
            while (vars.hasNext()) {
                BigInteger bigInteger;
                Map.Entry<String, ?> entry = vars.next();
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Ref) {
                    value = ((Ref)value).getValue();
                } else if (value instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)value;
                    if (bigDecimal.compareTo(maxLongValueBigDecimalView) < 0) {
                        value = bigDecimal.doubleValue();
                    }
                } else if (value instanceof BigInteger && (bigInteger = (BigInteger)value).compareTo(maxLongValueBigIntegerView) < 0) {
                    value = bigInteger.longValue();
                }
                bindings.putMember(key, value);
            }
        }

        private Object toJavaObject(Value value) {
            LocalDate date = null;
            LocalTime time = null;
            if (value.isDate()) {
                date = value.asDate();
            }
            if (value.isTime()) {
                time = value.asTime();
            }
            if (date != null) {
                if (time != null) {
                    return LocalDateTime.of(date, time);
                }
                return date;
            }
            if (time != null) {
                return time;
            }
            return value.as(Object.class);
        }
    }
}

