/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudself.query.util;

import cn.cloudself.query.config.QueryProConfig;
import cn.cloudself.query.exception.UnSupportException;
import cn.cloudself.query.util.ClassParser;
import cn.cloudself.query.util.Log;
import cn.cloudself.query.util.LogFactory;
import cn.cloudself.query.util.Ref;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BeanProxy<B> {
    private static final Map<Class<?>, BeanProxy<?>> beanProxyCaches = new HashMap();
    private static final Log logger = LogFactory.getLog(BeanProxy.class);
    protected final Class<B> clazz;

    @NotNull
    public static <B> BeanProxy<B> fromClass(@NotNull Class<B> clazz) {
        BeanProxy<?> cachedBeanProxy = beanProxyCaches.get(clazz);
        if (cachedBeanProxy != null) {
            return cachedBeanProxy;
        }
        ProxyTemplate beanProxy = Map.class.isAssignableFrom(clazz) ? new MapProxy<B>(clazz) : (QueryProConfig.computed.supportedColumnType().stream().anyMatch(it -> it.isAssignableFrom(clazz)) ? new BasicTypeProxy<B>(clazz) : new JavaBeanProxy<B>(clazz));
        beanProxyCaches.put(clazz, beanProxy);
        return beanProxy;
    }

    public static <B> BeanInstance<B> fromBean(B bean) {
        Class<?> clazz = bean.getClass();
        return new BeanInstance<B>(bean, BeanProxy.fromClass(clazz));
    }

    public static <B> BeanInstance<B> fromBean(B bean, Class<?> refer) {
        Class<?> clazz = bean.getClass();
        return new BeanInstance<B>(bean, BeanProxy.fromClass(clazz), refer);
    }

    public abstract BeanInstance<B> newInstance();

    @NotNull
    protected abstract ClassParser.ParsedClass getParsedClass();

    protected abstract void setProp(@NotNull Object var1, @NotNull String var2, @Nullable Object var3);

    @Nullable
    protected abstract Object getProp(@NotNull Object var1, @NotNull String var2);

    @Nullable
    protected abstract Class<?> getPropertyType(@NotNull String var1);

    @Nullable
    protected abstract B toRes(@NotNull Object var1);

    protected BeanProxy(Class<B> clazz) {
        this.clazz = clazz;
    }

    private static abstract class ProxyTemplate<B, O>
    extends BeanProxy<B> {
        @NotNull
        protected abstract O createInstance();

        protected abstract void setProperty(@NotNull O var1, @NotNull String var2, @Nullable Object var3);

        @Nullable
        protected abstract Object getProperty(@NotNull O var1, @NotNull String var2);

        @Nullable
        protected abstract B toResult(@NotNull O var1);

        @Override
        public BeanInstance<B> newInstance() {
            return new BeanInstance<O>(this.createInstance(), this);
        }

        @Override
        protected void setProp(@NotNull Object obj, @NotNull String prop, @Nullable Object val) {
            this.setProperty(obj, prop, val);
        }

        @Override
        @Nullable
        protected Object getProp(@NotNull Object obj, @NotNull String prop) {
            return this.getProperty(obj, prop);
        }

        @Override
        @Nullable
        protected B toRes(@NotNull Object obj) {
            return this.toResult(obj);
        }

        protected ProxyTemplate(@NotNull Class<B> clazz) {
            super(clazz);
        }
    }

    private static class JavaBeanProxy<B>
    extends ProxyTemplate<B, B> {
        private final ClassParser.ParsedClass parsedClass;
        private final Map<String, ClassParser.ParsedColumn> columns;

        protected JavaBeanProxy(@NotNull Class<B> clazz) {
            super(clazz);
            this.parsedClass = ClassParser.parse(clazz);
            this.columns = this.parsedClass.getColumns();
        }

        @Override
        @NotNull
        protected B createInstance() {
            try {
                return (B)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new UnSupportException(e, "{0} \u6ca1\u6709\u627e\u5230\u65e0\u53c2\u6784\u9020\u51fd\u6570\uff0c\u8be5\u7c7b\u662f\u4e00\u4e2aJavaBean\u5417, \u5bf9\u4e8eKotlin\uff0c\u9700\u4f7f\u7528kotlin-maven-noarg\u751f\u6210\u9ed8\u8ba4\u7684\u65e0\u53c2\u6784\u9020\u51fd\u6570\u6216\u5728\u751f\u6210\u5de5\u5177\u4e2d\u914d\u7f6eQueryProFileMaker.disableKtNoArgMode()\u6765\u751f\u6210\u9ed8\u8ba4\u7684\u6784\u9020\u51fd\u6570", this.clazz);
            }
        }

        @Override
        @NotNull
        protected ClassParser.ParsedClass getParsedClass() {
            return this.parsedClass;
        }

        @Override
        protected void setProperty(@NotNull B obj, @NotNull String prop, @Nullable Object val) {
            ClassParser.ParsedColumn column2 = this.columns.get(prop);
            if (column2 == null) {
                logger.warn("\u7ed9\u5b9a\u7684\u7c7b\u578b${clazz.simpleName}\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5$p, \u8be5\u5b57\u6bb5\u7684\u8d4b\u503c\u5df2\u8df3\u8fc7\u3002");
                return;
            }
            column2.getSetter().invoke(obj, val);
        }

        @Override
        @Nullable
        protected Object getProperty(@NotNull B obj, @NotNull String prop) {
            ClassParser.ParsedColumn column2 = this.columns.get(prop);
            if (column2 == null) {
                logger.warn("\u6ca1\u6709\u627e\u5230\u8be5\u5b57\u6bb5 $p");
                return null;
            }
            return column2.getGetter().invoke(obj);
        }

        @Override
        @Nullable
        protected Class<?> getPropertyType(@NotNull String prop) {
            return this.columns.get(prop).getJavaType();
        }

        @Override
        @Nullable
        protected B toResult(@NotNull B obj) {
            return obj;
        }
    }

    private static class BasicTypeProxy<B>
    extends ProxyTemplate<B, Ref<B>> {
        protected BasicTypeProxy(@NotNull Class<B> clazz) {
            super(clazz);
        }

        @Override
        @NotNull
        protected Ref<B> createInstance() {
            return new Ref<Object>(null);
        }

        @Override
        @NotNull
        protected ClassParser.ParsedClass getParsedClass() {
            throw new UnSupportException("\u4e0d\u652f\u6301\u57fa\u672c\u7c7b\u578b\u8f6cproperties", new Object[0]);
        }

        @Override
        protected void setProperty(@NotNull Ref<B> obj, @NotNull String prop, @Nullable Object val) {
            obj.setValue(val);
        }

        @Override
        @Nullable
        protected Object getProperty(@NotNull Ref<B> obj, @NotNull String prop) {
            return obj.getValue();
        }

        @Override
        @Nullable
        protected Class<?> getPropertyType(@NotNull String prop) {
            return this.clazz;
        }

        @Override
        @Nullable
        protected B toResult(@NotNull Ref<B> obj) {
            return obj.getValue();
        }
    }

    private static class MapProxy<B>
    extends ProxyTemplate<B, Map<String, Object>> {
        protected MapProxy(@NotNull Class<B> clazz) {
            super(clazz);
        }

        @Override
        @NotNull
        protected Map<String, Object> createInstance() {
            if (LinkedHashMap.class.isAssignableFrom(this.clazz)) {
                return new LinkedHashMap<String, Object>();
            }
            if (HashMap.class.isAssignableFrom(this.clazz)) {
                return new HashMap<String, Object>();
            }
            throw new UnSupportException("\u4e0d\u652f\u6301LinkedHashMap\u4e0eHashMap<String, Object>\u4ee5\u5916\u7684Map", new Object[0]);
        }

        @Override
        @NotNull
        protected ClassParser.ParsedClass getParsedClass() {
            throw new UnSupportException("\u4e0d\u652f\u6301Map\u8f6cproperties", new Object[0]);
        }

        @Override
        protected void setProperty(@NotNull Map<String, Object> obj, @NotNull String prop, @Nullable Object val) {
            obj.put(prop, val);
        }

        @Override
        @Nullable
        protected Object getProperty(@NotNull Map<String, Object> obj, @NotNull String prop) {
            return obj.get(prop);
        }

        @Override
        @Nullable
        protected Class<?> getPropertyType(@NotNull String prop) {
            return null;
        }

        @Override
        @Nullable
        protected B toResult(@NotNull Map<String, Object> obj) {
            return (B)obj;
        }
    }

    public static class BeanInstance<B> {
        private final B instance;
        private final BeanProxy<B> proxy;
        private final Class<?> clazz;

        public BeanInstance(@NotNull B instance, @NotNull BeanProxy<B> proxy) {
            this.instance = instance;
            this.proxy = proxy;
            this.clazz = null;
        }

        public BeanInstance(@NotNull B instance, @NotNull BeanProxy<B> proxy, @Nullable Class<?> clazz) {
            this.instance = instance;
            this.proxy = proxy;
            this.clazz = clazz;
        }

        @NotNull
        public BeanInstance<B> setProperty(@NotNull String db_field_name, @Nullable Object value) {
            this.proxy.setProp(this.instance, db_field_name, value);
            return this;
        }

        @Nullable
        public Object getProperty(@NotNull String db_field_name) {
            return this.proxy.getProp(this.instance, db_field_name);
        }

        @Nullable
        public Class<?> getPropertyType(@NotNull String db_field_name) {
            if (this.clazz != null && this.clazz != this.proxy.clazz) {
                ClassParser.ParsedColumn column2 = ClassParser.parse(this.clazz).getColumnDbFieldName(db_field_name);
                if (column2 == null) {
                    return null;
                }
                return column2.getJavaType();
            }
            if (this.instance instanceof Map) {
                Object val = ((Map)this.instance).get(db_field_name);
                if (val == null) {
                    return null;
                }
                return val.getClass();
            }
            return this.proxy.getPropertyType(db_field_name);
        }

        @Nullable
        public B toBean() {
            return this.proxy.toRes(this.instance);
        }

        public Class<B> getBeanType() {
            return this.proxy.clazz;
        }

        public ClassParser.ParsedClass getParsedClass() {
            return this.proxy.getParsedClass();
        }

        @NotNull
        public Iterator<Map.Entry<String, Object>> iterator() {
            if (this.instance instanceof Map) {
                Map mapInstance = (Map)this.instance;
                final Iterator iterator = mapInstance.entrySet().iterator();
                return new Iterator<Map.Entry<String, Object>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        Map.Entry next = (Map.Entry)iterator.next();
                        Object key = next.getKey();
                        if (key instanceof String) {
                            return new AbstractMap.SimpleEntry<String, Object>((String)key, next.getValue());
                        }
                        throw new UnSupportException("\u4e0d\u652f\u6301\u975eMap<String, ?>\u7c7b\u578b\u7684Map", new Object[0]);
                    }
                };
            }
            Map<String, ClassParser.ParsedColumn> columns = this.getParsedClass().getColumns();
            final Iterator<Map.Entry<String, ClassParser.ParsedColumn>> iterator = columns.entrySet().iterator();
            return new Iterator<Map.Entry<String, Object>>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    Map.Entry next = (Map.Entry)iterator.next();
                    return new AbstractMap.SimpleEntry<String, Object>((String)next.getKey(), ((ClassParser.ParsedColumn)next.getValue()).getGetter().invoke(instance));
                }
            };
        }
    }
}

