/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudself.query;

import cn.cloudself.query.config.HashMapStore;
import cn.cloudself.query.config.QueryProConfigDb;
import cn.cloudself.query.exception.IllegalCall;
import cn.cloudself.query.exception.IllegalParameters;
import cn.cloudself.query.psi.structure.QueryStructureAction;
import cn.cloudself.query.resolver.DbType;
import cn.cloudself.query.resolver.Resolver;
import cn.cloudself.query.util.IO;
import cn.cloudself.query.util.Pair;
import cn.cloudself.query.util.SqlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import kotlin.jvm.functions.Function0;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class QueryProSql {
    public static Action create(@NotNull String sql, Object ... params) {
        if (sql == null) {
            QueryProSql.$$$reportNull$$$0(0);
        }
        return new Action(sql, QueryProSql.formatVararg(params));
    }

    public static Action create(@NotNull InputStream inputStream, Object ... params) {
        if (inputStream == null) {
            QueryProSql.$$$reportNull$$$0(1);
        }
        return new Action(IO.readBytesAsString(inputStream), QueryProSql.formatVararg(params));
    }

    public static Action createFromClassPath(@NotNull String path, Object ... params) {
        Action action;
        block10: {
            if (path == null) {
                QueryProSql.$$$reportNull$$$0(2);
            }
            InputStream is = QueryProSql.class.getClassLoader().getResourceAsStream(path);
            try {
                if (is == null) {
                    throw new IllegalParameters("\u8def\u5f84{0}\u53ef\u80fd\u4e0d\u662f\u6807\u51c6\u7684ClassPath", path);
                }
                action = QueryProSql.create(is, params);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return action;
    }

    public static InsertAction create() {
        return new InsertAction();
    }

    public static BatchAction createBatch() {
        return new BatchAction();
    }

    private static Object[] formatVararg(Object[] vararg) {
        Object first;
        if (vararg == null) {
            return null;
        }
        if (vararg.length > 0 && (first = vararg[0]) instanceof Collection) {
            if (vararg.length > 1) {
                throw new IllegalCall("\u7b2c\u4e00\u4e2a\u53c2\u6570\u4e3acollection\u65f6\uff0c\u53c2\u6570\u4e2a\u6570\u4e0d\u80fd\u5927\u4e8e1\u3002", new Object[0]);
            }
            return ((Collection)first).toArray();
        }
        return vararg;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "cn/cloudself/query/QueryProSql";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromClassPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class InsertAction
    extends AbstractAction<InsertAction> {
        @Override
        protected InsertAction that() {
            return this;
        }

        public InsertAction maxParameterSize(Integer size) {
            this.config.maxParameterSize(size);
            return this.that();
        }

        @SafeVarargs
        public final <V> void insert(String table, Map<String, V> ... objs) {
            this.insert(table, Arrays.asList(objs), null);
        }

        public <V, M extends Map<String, V>> void insert(String table, Collection<M> objs) {
            this.insert(table, objs, null);
        }

        public <ID, V, M extends Map<String, V>> List<ID> insert(String table, Collection<M> objs, Class<ID> idColumnClazz) {
            return (List)Resolver.create((Function0<? extends HashMapStore>)((Function0)() -> this.store)).use(resolver -> resolver.insert(objs, table, idColumnClazz));
        }
    }

    public static class BatchAction
    extends AbstractAction<BatchAction> {
        private String[] sqlArray;
        private Object[][] paramsArray;

        @Override
        protected BatchAction that() {
            return this;
        }

        public BatchAction autoSplit(@Language(value="SQL") String sqlGroup, Object ... params) {
            List<Pair<String, Integer>> sqlAndCountArr = SqlUtils.splitBySemicolonAndCountQuestionMark(sqlGroup);
            int size = sqlAndCountArr.size();
            this.sqlArray = new String[size];
            this.paramsArray = new Object[size][];
            int i = 0;
            int j = 0;
            for (Pair<String, Integer> sqlAndCount : sqlAndCountArr) {
                String sql = sqlAndCount.first();
                Integer count = sqlAndCount.second();
                this.sqlArray[i] = sql;
                this.paramsArray[i] = Arrays.copyOfRange(params, j, (int)count);
                ++i;
                j += count.intValue();
            }
            return this;
        }

        public <T> T exec(Class<T> clazz) {
            return (T)Resolver.create((Function0<? extends HashMapStore>)((Function0)() -> this.store)).use(resolver -> resolver.exec(this.sqlArray, this.paramsArray, clazz));
        }

        public int exec() {
            return this.exec(Integer.class);
        }
    }

    public static class Action
    extends AbstractAction<Action> {
        @Language(value="SQL")
        private final String sql;
        private final Object[] params;

        public Action(@Language(value="SQL") String sql, Object[] params) {
            this.sql = sql;
            this.params = params;
        }

        @Override
        protected Action that() {
            return this;
        }

        public <T> T queryOne(@NotNull Class<T> clazz) {
            if (clazz == null) {
                Action.$$$reportNull$$$0(0);
            }
            return this.query(clazz).get(0);
        }

        public Map<String, Object> queryOne() {
            return this.query().get(0);
        }

        public <T> List<T> query(@NotNull Class<T> clazz) {
            if (clazz == null) {
                Action.$$$reportNull$$$0(1);
            }
            return (List)Resolver.create((Function0<? extends HashMapStore>)((Function0)() -> this.store)).use(resolver -> resolver.resolve(this.sql, this.params, clazz, QueryStructureAction.SELECT));
        }

        public List<Map<String, Object>> query() {
            return this.query(HashMap.class).stream().map(m -> m).collect(Collectors.toList());
        }

        public int exec() {
            return (Integer)((List)Resolver.create((Function0<? extends HashMapStore>)((Function0)() -> this.store)).use(resolver -> resolver.resolve(this.sql, this.params, Integer.class, QueryStructureAction.UPDATE))).get(0);
        }

        public BatchAction autoSplit() {
            BatchAction batchAction = new BatchAction().autoSplit(this.sql, this.params);
            batchAction.store.copyFrom(this.store);
            return batchAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "clazz";
            objectArray2[1] = "cn/cloudself/query/QueryProSql$Action";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "queryOne";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "query";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class AbstractAction<T> {
        protected final HashMapStore store = new HashMapStore();
        protected final QueryProConfigDb config = new QueryProConfigDb(this.store);

        protected abstract T that();

        public T dbType(DbType dbType2) {
            this.config.dbType(dbType2);
            return this.that();
        }

        public T take(Function<T, T> factor) {
            return factor.apply(this.that());
        }

        public T ofConnection(Connection connection2) {
            this.config.connection(connection2);
            return this.that();
        }

        public T ofDataSource(DataSource dataSource) {
            this.config.dataSource(dataSource);
            return this.that();
        }
    }
}

