<#-- @ftlvariable name="m" type="cn.cloudself.query.util.TemplateModel" -->
<#assign ClassName = m._ClassName/>
<#assign EntityName = m._EntityName/>
<#assign IdType = (m.id.javaTypeStr)!"Long"/>
@file:Suppress("unused")

package ${m.packagePath}

import ${m.entityPackage}.${EntityName}
<#if m.hasBigDecimal>import java.math.BigDecimal
</#if><#if m.hasDate>import java.util.Date
</#if>import cn.cloudself.query.*
import cn.cloudself.query.psi.*
import cn.cloudself.query.psi.structure.*
import org.jetbrains.annotations.Contract;


class Impl${ClassName} {
    companion object {
        const val TABLE_NAME = "${m.db_name}"
        private fun createField(column: String) = Field(TABLE_NAME, column)
    }

    abstract class CommonField${"<"}T: Any, RUN_RES>: AbstractExpression${"<"}T, RUN_RES, WhereField${"<"}T, RUN_RES>, OrderByField${"<"}T, RUN_RES>, ColumnLimiterField${"<"}T, RUN_RES>, ColumnsLimiterField${"<"}T, RUN_RES>>() {
        override fun createWhereField(qs: QueryStructure, payload: QueryPayload) = WhereField${"<"}T, RUN_RES>(qs, payload, clazz)
        override fun createOrderByField(qs: QueryStructure, payload: QueryPayload) = OrderByField${"<"}T, RUN_RES>(qs, payload, clazz)
        override fun createColumnLimitField(qs: QueryStructure, payload: QueryPayload ) = ColumnLimiterField${"<"}T, RUN_RES>(qs, payload, clazz)
        override fun createColumnsLimitField(qs: QueryStructure, payload: QueryPayload) = ColumnsLimiterField${"<"}T, RUN_RES>(qs, payload, clazz)
    }

    class WhereField${"<"}T: Any, RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class${"<"}T>
    ): CommonField${"<"}T, RUN_RES>() {
        override val fieldType = ExpressionType.WHERE
        private fun byColumn(column: String) = Keywords(createField(column), queryStructure, payload, ::createWhereField)
        private fun byColumn(column: String, objs: Array${"<"}out Any>) = byColumn(column).let { if (objs.size == 1) it.equalTo(objs[0]) else it.`in`(*objs) }

    <#list m.columns as field>
        val ${field.propertyName} = byColumn("${field.db_name}")
        @Contract(pure = true)
        fun ${field.propertyName}(${field.propertyName}List: List<${field.ktTypeStr}>) = byColumn("${field.db_name}", ${field.propertyName}List.toTypedArray())
        @Contract(pure = true)
        fun ${field.propertyName}(vararg ${field.propertyName}s: ${field.ktTypeStr}) = byColumn("${field.db_name}", <#if field.primary>${field.propertyName}s.toTypedArray()</#if><#if !field.primary>${field.propertyName}s</#if>)
    </#list>
    }

    class OrderByField${"<"}T: Any, RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class${"<"}T>
    ): CommonField${"<"}T, RUN_RES>() {
        override val fieldType = ExpressionType.ORDER_BY
        private fun byColumn(column: String) = KeywordsOrderBy(createField(column), queryStructure, payload, ::createOrderByField)

    <#list m.columns as field>
        @Contract(pure = true)
        fun ${field.propertyName}() = byColumn("${field.db_name}")
    </#list>
    }

    class ColumnLimiterField${"<"}T: Any, RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class${"<"}T>
    ): CommonField${"<"}T, RUN_RES>() {
        override val fieldType = ExpressionType.COLUMN_LIMITER

    <#list m.columns as field>
        fun ${field.propertyName}() = getColumn(createField("${field.db_name}"), ${field.ktTypeStr}::class.java)
    </#list>
    }

    class ColumnsLimiterField${"<"}T: Any, RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class${"<"}T>
    ): CommonField${"<"}T, RUN_RES>() {
        override val fieldType = ExpressionType.COLUMNS_LIMITER
        private fun createColumnsLimiterField(column: String): ColumnsLimiterField${"<"}T, RUN_RES> {
            queryStructure.fields = queryStructure.fields + createField(column)
            return this
        }

    <#list m.columns as field>
        @Contract(pure = true)
        fun ${field.propertyName}() = createColumnsLimiterField("${field.db_name}")
    </#list>
    }

    class UpdateSetField(
        private val qs: QueryStructure,
        payload: QueryPayload
    ): UpdateSetDefinedExpression${"<"}WhereField${"<"}Boolean, Boolean>>(qs, payload, { q, p -> WhereField(q, p, Boolean::class.java) }) {
        private fun createUpdateSetField(key: String, value: Any) = this.also {
            @Suppress("UNCHECKED_CAST") val map = qs.update?.data as MutableMap${"<"}String, Any>
            map[key] = value
        }

    <#list m.columns as field>
        <#assign prop = field.propertyName/>
        @Contract(pure = true)
        fun ${prop}(${prop}: Any) = createUpdateSetField("${field.db_name}", ${prop})
    </#list>
    }
}

private fun createQuery() =
    QueryPro<
            ${EntityName},
            ${IdType},
            Impl${ClassName}.WhereField${"<"}${EntityName}, List${"<"}${EntityName}>>,
            Impl${ClassName}.OrderByField${"<"}${EntityName}, List${"<"}${EntityName}>>,
            Impl${ClassName}.UpdateSetField,
            Impl${ClassName}.WhereField${"<"}Boolean, Boolean>,
            Impl${ClassName}.WhereField${"<"}Boolean, Boolean>,
    > (
        ${ClassName}::class.java,
        ${EntityName}::class.java,
        QueryStructure(from = QueryStructureFrom(Impl${ClassName}.TABLE_NAME)),
        { qs, payload -> Impl${ClassName}.WhereField(qs, payload, ${EntityName}::class.java) },
        { qs, payload -> Impl${ClassName}.OrderByField(qs, payload, ${EntityName}::class.java) },
        { qs, payload -> Impl${ClassName}.UpdateSetField(qs, payload) },
        { qs, payload -> Impl${ClassName}.WhereField(qs, payload, Boolean::class.java) },
        { qs, payload -> Impl${ClassName}.WhereField(qs, payload, Boolean::class.java) },
    )

object ${ClassName} {
<#list m.queryProDelegate as di>
<#list di.annotations as annotation>
    ${annotation}
</#list>
<#--noinspection FtlReferencesInspection-->
    fun ${di.method}(<#list di.args as arg><#if arg.vararg>vararg </#if>${arg.variableName}: <@arg.variableType?interpret /><#sep>, </#list>) = createQuery().${di.method}(<#list di.args as arg><#if arg.vararg>*</#if>${arg.variableName}<#sep>, </#list>)
</#list>
}

