package cn.cloudself.query.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

public class IO {
    public static  <T> T readBytes(InputStream inputStream, Function<ByteArrayOutputStream, T> transformer) throws IOException {
        try (final ByteArrayOutputStream os = new ByteArrayOutputStream()) {
            final byte[] buffer = new byte[1024];
            for (int length; (length = inputStream.read(buffer)) != -1; ) {
                os.write(buffer, 0, length);
            }
            return transformer.apply(os);
        }
    }

    public static byte[] readBytes(InputStream inputStream) {
        try {
            return readBytes(inputStream, ByteArrayOutputStream::toByteArray);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readBytesAsString(InputStream inputStream) {
        try {
            return readBytes(inputStream, it -> {
                try {
                    return it.toString(StandardCharsets.UTF_8.name());
                } catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            });
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
