package cn.cloudself.query.psi.structure

/**
 * 描述查询，更新，插入，删除的一个可序列化的结构
 */
data class QueryStructure(
    var action: QueryStructureAction = QueryStructureAction.SELECT,
    var update: Update? = null,
    var insert: Insert? = null,
    var distinct: Boolean = false,
    var fields: List<Field> = listOf(),
    var from: QueryStructureFrom = QueryStructureFrom(),
    var where: List<WhereClause> = listOf(),
    var orderBy: List<OrderByClause> = listOf(),
    var limit: Pair<Int, Int>? = null,
)
