package cn.cloudself.query.psi

import cn.cloudself.query.psi.structure.QueryPayload
import cn.cloudself.query.psi.structure.QueryStructure
import cn.cloudself.query.psi.structure.QueryStructureAction

open class UpdateSetDefinedExpression<UPDATE_BY_FIELD: AbstractExpression<*, *, *, *, *, *>>(
    private val queryStructure: QueryStructure,
    private val payload: QueryPayload,
    private val createUpdateByField: CreateQueryField<UPDATE_BY_FIELD>,
) {
    @get:JvmName("where")
    val where = createUpdateByField(queryStructure.apply { action = QueryStructureAction.UPDATE }, payload)

    fun run(): Boolean = createUpdateByField(queryStructure, payload).run() as Boolean
}