package cn.cloudself.query.psi

import cn.cloudself.query.psi.structure.Field
import cn.cloudself.query.psi.structure.OrderByClause
import cn.cloudself.query.psi.structure.QueryPayload
import cn.cloudself.query.psi.structure.QueryStructure
import org.jetbrains.annotations.Contract

class KeywordsOrderBy<F: AbstractExpression<*, *, *, *, *, *>>(
    private val field: Field,
    private val queryStructure: QueryStructure,
    private val payload: QueryPayload,
    private val createQueryField: CreateQueryField<F>,
) {
    @Contract(pure = true)
    fun asc() = with(OrderByClause(field, "asc"))
    @Contract(pure = true)
    fun desc() = with(OrderByClause(field, "desc"))

    private fun with(orderBy: OrderByClause): F {
        queryStructure.orderBy = queryStructure.orderBy + orderBy
        return createQueryField(queryStructure, payload)
    }
}
