package cn.cloudself.query.psi

import cn.cloudself.query.exception.IllegalCall
import cn.cloudself.query.exception.IllegalParameters
import cn.cloudself.query.psi.structure.Field
import cn.cloudself.query.psi.structure.QueryPayload
import cn.cloudself.query.psi.structure.QueryStructure
import cn.cloudself.query.psi.structure.WhereClause
import org.jetbrains.annotations.Contract

class KeywordsNot<F : AbstractExpression<*, *, *, *, *, *>>(
    private val field: Field,
    private val queryStructure: QueryStructure,
    private val payload: QueryPayload,
    private val createQueryField: CreateQueryField<F>,
) {
    @Contract(pure = true)
    fun eq(value: Any) = with(WhereClause(field, "<>", value))
    @Contract(pure = true)
    fun equalTo(value: Any) = with(WhereClause(field, "<>", value))
    @Contract(pure = true)
    fun between(start: Any, end: Any) = with(WhereClause(field, Const.NOT_BETWEEN, arrayOf(start, end)))
    @Contract(pure = true)
    fun like(str: String) = with(WhereClause(field, Const.NOT_LIKE, str))
    @Contract(pure = true)
    fun `in`(vararg values: Any): F {
        val inArr = if (values.isNotEmpty() && values[0] is Collection<*>) {
            if (values.size > 1) {
                throw IllegalCall("not in查询的第一个参数为collection时，不支持多个collection。")
            }
            (values[0] as Collection<*>).toTypedArray()
        } else {
            values
        }

        return if (inArr.isEmpty())
            throw IllegalParameters("not in查询不能设置空参数")
        else
            with(WhereClause(field, Const.NOT_IN, inArr))
    }
    @Contract(pure = true)
    fun nul() = with(WhereClause(field = field, operator = Const.IS_NOT_NULL))

    private fun with(whereClause: WhereClause): F {
        queryStructure.where = queryStructure.where + whereClause
        return createQueryField(queryStructure, payload)
    }
}