package cn.cloudself.query.psi

import cn.cloudself.query.exception.IllegalParameters
import cn.cloudself.query.psi.structure.*
import org.jetbrains.annotations.Contract


class KeywordsIgnoreCase<F : AbstractExpression<*, *, *, *, *, *>>(
    private val field: Field,
    private val queryStructure: QueryStructure,
    private val payload: QueryPayload,
    private val createQueryField: CreateQueryField<F>,
) {
    @Contract(pure = true)
    fun eq(value: Any) = with(WhereClause(upperField(field), Const.EQUAL, value, WhereClauseCommands.UPPER_CASE))
    @Contract(pure = true)
    fun equalTo(value: Any) = with(WhereClause(upperField(field), Const.EQUAL, value, WhereClauseCommands.UPPER_CASE))
    @Contract(pure = true)
    fun like(str: String) = with(WhereClause(upperField(field), Const.LIKE, str, WhereClauseCommands.UPPER_CASE))
    @Contract(pure = true)
    fun `in`(vararg values: Any) =
        if (values.isEmpty()) throw IllegalParameters("in查询+ignore case不能设置空参数")
        else with(WhereClause(upperField(field), Const.IN, values, WhereClauseCommands.UPPER_CASE))

    private fun upperField(field: Field) = Field(table = field.table, column = field.column)
    private fun with(whereClause: WhereClause): F {
        queryStructure.where = queryStructure.where + whereClause
        return createQueryField(queryStructure, payload)
    }
}
