package cn.cloudself.query.psi

import cn.cloudself.query.exception.IllegalCall
import cn.cloudself.query.psi.*
import cn.cloudself.query.psi.structure.*
import cn.cloudself.query.util.onlyAZaz_
import org.jetbrains.annotations.Contract
import java.io.InputStream

class Keywords<F : AbstractExpression<*, *, *, *, *, *>>(
    private val field: Field,
    private val queryStructure: QueryStructure,
    private val payload: QueryPayload,
    private val createQueryField: CreateQueryField<F>,
) {
    @get:Contract(pure = true)
    @get:JvmName("is")
    val `is` = this

    @get:Contract(pure = true)
    @get:JvmName("not")
    val not = KeywordsNot(field, queryStructure, payload, createQueryField)

    @get:Contract(pure = true)
    @get:JvmName("ignoreCase")
    val ignoreCase = KeywordsIgnoreCase(field, queryStructure, payload, createQueryField)

    @Contract(pure = true)
    fun eq(value: Any) = with(WhereClause(field, Const.EQUAL, value))
    @Contract(pure = true)
    fun equalTo(value: Any) = with(WhereClause(field, Const.EQUAL, value))
    @Contract(pure = true)
    fun between(start: Any, end: Any) = with(WhereClause(field, Const.BETWEEN, arrayOf(start, end)))
    @Contract(pure = true)
    fun lessThan(value: Any) = with(WhereClause(field, "<", value))
    @Contract(pure = true)
    fun lessThanOrEqual(value: Any) = with(WhereClause(field, "<=", value))
    @Contract(pure = true)
    fun graterThan(value: Any) = with(WhereClause(field, ">", value))
    @Contract(pure = true)
    fun graterThanOrEqual(value: Any) = with(WhereClause(field, ">=", value))
    @Contract(pure = true)
    fun like(str: String) = with(WhereClause(field, Const.LIKE, str))

    /**
     * in 查询 支持vararg, eg: in(1, 2, 3), in(intArray), etc.  <br/>
     * 支持有且仅有一个Collection作为参数, eg: in(list), in(set), etc.
     */
    @Contract(pure = true)
    fun `in`(vararg values: Any): F {
        val inArr = if (values.isNotEmpty() && values[0] is Collection<*>) {
            if (values.size > 1) {
                throw IllegalCall("in查询的第一个参数为collection时，不支持多个collection。")
            }
            (values[0] as Collection<*>).toTypedArray()
        } else {
            values
        }

        return if (inArr.isEmpty()) {
            val table = field.table
            with(WhereClause(null, operator = "", sql = "false/* WARN: ${if (table == null) "" else onlyAZaz_(table)}${if (table == null) "" else "."}${onlyAZaz_(field.column)} in empty*/"))
        } else {
            with(WhereClause(field, Const.IN, inArr))
        }
    }
    @Contract(pure = true)
    fun nul() = with(WhereClause(field = field, operator = Const.IS_NULL))
    @Contract(pure = true)
    fun isNull() = with(WhereClause(field = field, operator = Const.IS_NULL))
    @Contract(pure = true)
    fun isNotNull() = with(WhereClause(field = field, operator = Const.IS_NOT_NULL))
    @Contract(pure = true)
    fun sql(sql: String) = with(WhereClause(field = field, operator = "", sql = sql))

    private fun with(whereClause: WhereClause): F {
        queryStructure.where = queryStructure.where + whereClause
        return createQueryField(queryStructure, payload)
    }
}
