package cn.cloudself.query.psi

import cn.cloudself.query.*
import cn.cloudself.query.exception.IllegalCall
import cn.cloudself.query.exception.IllegalImplements
import cn.cloudself.query.resolver.Resolver
import cn.cloudself.query.psi.structure.*
import cn.cloudself.query.util.Pageable
import java.util.*

abstract class FinalOperators<
        T : Any,
        RUN_RES,
        COLUMN_LIMITER_FILED: FinalOperators<T, RUN_RES, COLUMN_LIMITER_FILED, COLUMNS_LIMITER_FILED>,
        COLUMNS_LIMITER_FILED: FinalOperators<T, RUN_RES, COLUMN_LIMITER_FILED, COLUMNS_LIMITER_FILED>,
> {
    protected abstract val queryStructure: QueryStructure
    protected abstract val payload: QueryPayload
    protected abstract val clazz: Class<T>
    protected abstract fun createColumnLimitField(qs: QueryStructure, payload: QueryPayload): COLUMN_LIMITER_FILED
    protected abstract fun createColumnsLimitField(qs: QueryStructure, payload: QueryPayload): COLUMNS_LIMITER_FILED
    protected abstract fun createField(qs: QueryStructure, payload: QueryPayload): FinalOperators<T, RUN_RES, COLUMN_LIMITER_FILED, COLUMNS_LIMITER_FILED>

    @Suppress("UNCHECKED_CAST")
    private fun <R: Any> resolve(clazz: Class<R>): List<R> {
        return Resolver.create(this.clazz as Class<Any>, queryStructure, payload).use {
            resolve(it, payload, clazz)
        }
    }

    fun distinct(): FinalOperators<T, RUN_RES, COLUMN_LIMITER_FILED, COLUMNS_LIMITER_FILED> {
        if (queryStructure.orderBy.isNotEmpty()) {
            throw IllegalCall("不支持 distinct + orderBy. 可使用Java代码手动去重。")
        }
        queryStructure.distinct = true
        return createField(queryStructure, payload)
    }

    fun limit(limit: Int): FinalOperators<T, RUN_RES, COLUMN_LIMITER_FILED, COLUMNS_LIMITER_FILED> {
        return limit(0, limit)
    }

    @Suppress("MemberVisibilityCanBePrivate")
    fun limit(start: Int, limit: Int): FinalOperators<T, RUN_RES, COLUMN_LIMITER_FILED, COLUMNS_LIMITER_FILED> {
        queryStructure.limit = start to limit
        return createField(queryStructure, payload)
    }

    protected open fun <T: Any>getColumn(field: Field, clazz: Class<T>): List<T?> {
        queryStructure.fields = queryStructure.fields + field
        val rows = createField(queryStructure, payload).runAsMap()
        return rows.map {
            val f = it[field.column] ?: return@map null
            val fieldJavaClass = f.javaClass
            if (clazz.isAssignableFrom(f.javaClass)) {
                @Suppress("UNCHECKED_CAST")
                return@map f as T
            }
            val targetPrimitiveType = clazz.kotlin.javaPrimitiveType ?: return@map null
            val objPrimitiveType = fieldJavaClass.kotlin.javaPrimitiveType
            if (targetPrimitiveType == objPrimitiveType) {
                @Suppress("UNCHECKED_CAST")
                f as T
            } else {
                null
            }
        }
    }

    fun columnsLimiter(): COLUMNS_LIMITER_FILED {
        return createColumnsLimitField(queryStructure, payload)
    }

    fun columnLimiter(): COLUMN_LIMITER_FILED {
        return createColumnLimitField(queryStructure, payload)
    }

    @Suppress("MemberVisibilityCanBePrivate")
    fun count(): Int {
        if (queryStructure.action != QueryStructureAction.SELECT) {
            throw IllegalCall("非SELECT语句不能使用count方法")
        }
        queryStructure.fields = listOf(Field(column = "count(*)"))
        return resolve(Int::class.java)[0]
    }

    fun runLimit1Opt(): Optional<T> {
        return Optional.ofNullable(runLimit1())
    }

    fun runLimit1(): T? {
        queryStructure.limit = 0 to 1
        val results = createField(queryStructure, payload).queryAll()
        return if (results.isEmpty()) null else results[0]
    }

    fun run(): RUN_RES {
        @Suppress("UNCHECKED_CAST")
        return when (queryStructure.action) {
            QueryStructureAction.SELECT -> {
                queryAll() as RUN_RES
            }
            QueryStructureAction.DELETE, QueryStructureAction.UPDATE -> {
                val results = queryAll()
                if (results.isEmpty())
                    throw IllegalImplements("DELETE, UPDATE需返回长度为1的List<Boolean>")
                else
                    results[0] as RUN_RES
            }
            QueryStructureAction.INSERT -> {
                throw IllegalCall("run方法不支持INSERT")
            }
        }
    }

    fun runAsMap(): List<Map<String, Any?>> = resolve(mutableMapOf<String, Any>().javaClass)

    private fun queryAll(): List<T> = resolve(clazz)

    fun pageable(): Pageable<T> {
        return Pageable.create(
            { count() },
            { start, limit ->
                queryStructure.limit = start to limit
                resolve(clazz)
            }
        )
    }
}