package cn.cloudself.query.psi

import cn.cloudself.query.*
import cn.cloudself.query.exception.IllegalCall
import cn.cloudself.query.psi.structure.*
import java.util.*

typealias CreateQueryField<F> = (QueryStructure, QueryPayload) -> F

abstract class AbstractExpression<
        T: Any,
        RUN_RES,
        WHERE_FIELD: AbstractExpression<T, RUN_RES, WHERE_FIELD, ORDER_BY_FIELD, COLUMN_LIMITER_FILED, COLUMNS_LIMITER_FILED>,
        ORDER_BY_FIELD: AbstractExpression<T, RUN_RES, WHERE_FIELD, ORDER_BY_FIELD, COLUMN_LIMITER_FILED, COLUMNS_LIMITER_FILED>,
        COLUMN_LIMITER_FILED: AbstractExpression<T, RUN_RES, WHERE_FIELD, ORDER_BY_FIELD, COLUMN_LIMITER_FILED, COLUMNS_LIMITER_FILED>,
        COLUMNS_LIMITER_FILED: AbstractExpression<T, RUN_RES, WHERE_FIELD, ORDER_BY_FIELD, COLUMN_LIMITER_FILED, COLUMNS_LIMITER_FILED>,
>: FinalOperators<T, RUN_RES, COLUMN_LIMITER_FILED, COLUMNS_LIMITER_FILED>() {
    protected abstract val fieldType: ExpressionType
    protected abstract fun createWhereField(qs: QueryStructure, payload: QueryPayload): WHERE_FIELD
    protected abstract fun createOrderByField(qs: QueryStructure, payload: QueryPayload): ORDER_BY_FIELD
    override fun createField(qs: QueryStructure, payload: QueryPayload): WHERE_FIELD {
        return createWhereField(qs, payload)
    }

    fun customColumn(column: String) = Keywords(Field(column = column), queryStructure, payload, this::createWhereField)

    fun and(): WHERE_FIELD {
        if (fieldType != ExpressionType.WHERE) {
            throw RuntimeException("$fieldType can not call and, usage: .orderBy().id.desc().name.asc()")
        }
        @Suppress("UNCHECKED_CAST")
        return this as WHERE_FIELD
    }

    @JvmOverloads
    fun or(factor: ((f: WHERE_FIELD) -> WHERE_FIELD)? = null): WHERE_FIELD {
        if (fieldType != ExpressionType.WHERE) {
            throw RuntimeException("$fieldType can not call and, usage: .orderBy().id.desc().name.asc()")
        }

        if (factor == null) {
            queryStructure.where = queryStructure.where + WhereClause(operator = Const.OR)
            return createWhereField(queryStructure, payload)
        }

        val vTempQueryStructure = QueryStructure(from = QueryStructureFrom("v_temp")) // v_temp会消失, 只取where
        val orWhereClauses = factor(createWhereField(vTempQueryStructure, payload)).queryStructure.where
        queryStructure.where = queryStructure.where + WhereClause(operator = Const.OR, value = orWhereClauses)
        return createWhereField(queryStructure, payload)
    }

    fun par(factor: ((f: WHERE_FIELD) -> WHERE_FIELD)): WHERE_FIELD {
        if (fieldType != ExpressionType.WHERE) {
            throw RuntimeException("$fieldType can not call and, usage: .orderBy().id.desc().name.asc()")
        }

        val vTempQueryStructure = QueryStructure(from = QueryStructureFrom("v_temp")) // v_temp会消失, 只取where
        val parWhereClauses = factor(createWhereField(vTempQueryStructure, payload)).queryStructure.where
        val newWhereClause = queryStructure.where + WhereClause(operator = Const.OPEN_PAR) + parWhereClauses + WhereClause(operator = Const.CLOSE_PAR)
        queryStructure.where = newWhereClause
        return createWhereField(queryStructure, payload)
    }

    fun parLeft(): WHERE_FIELD {
        queryStructure.where = queryStructure.where + WhereClause(operator = Const.OPEN_PAR)
        return createWhereField(queryStructure, payload)
    }

    fun parRight(): WHERE_FIELD {
        queryStructure.where = queryStructure.where + WhereClause(operator = Const.CLOSE_PAR)
        return createWhereField(queryStructure, payload)
    }

    fun sql(sql: String): WHERE_FIELD {
        queryStructure.where = queryStructure.where + WhereClause(operator = "", sql = sql)
        return createWhereField(queryStructure, payload)
    }

    fun orderBy(): ORDER_BY_FIELD {
        if (queryStructure.distinct) {
            throw IllegalCall("不支持 distinct + orderBy. 可使用Java代码手动去重。")
        }
        return createOrderByField(queryStructure, payload)
    }
}
