package cn.cloudself.query.plus

import cn.cloudself.query.psi.*
import cn.cloudself.query.psi.structure.*
import cn.cloudself.query.util.ListEx

class PlusManyTable<MAIN: Any> constructor(
    private val queryStructure: QueryStructure,
    private val payload: QueryPayload,
    private val clazz: Class<MAIN>,
) {
    inner class On<NEW: Any> constructor(
        private val type: JoinType,
        private val newClazz: Class<*>,
        private val alias: String? = null,
    ) {
        private fun on(left: Column, right: Column): PlusManyTable<MAIN>.Joined {
            val table = newClazz.toTable()
            val joinerOns = listOf(FromJoinerOn(left, right))
            queryStructure.from.joins.add(FromJoiner(type, table, joinerOns, alias))
            return PlusManyTable(queryStructure, payload, clazz).Joined()
        }

        fun <T: Any> on(t: Col<T>, tn: Col2<NEW>) = on(t.toField(), tn.toField())
        fun <TA: Any> on(table1alias: String, table1column: Col1<TA>, tableNewColumn: Col<NEW>) = on(table1column.toField(table1alias), tableNewColumn.toField())
        fun <TA: Any> on(tableNewColumn: Col<NEW>, table1alias: String, table1column: Col1<TA>) = on(table1column.toField(table1alias), tableNewColumn.toField())
        fun <TA: Any, TN: Any> on(table1alias: String, table1column: Col1<TA>, table2alias: String, table2column: Col2<TN>) = on(table1column.toField(table1alias), table2column.toField(table2alias))
    }

    abstract inner class Field<RUN_RES>: AbstractExpression<MAIN, RUN_RES, WhereField<RUN_RES>, OrderByField<RUN_RES>, ColumnLimiterField<RUN_RES>, ColumnsLimiterField<RUN_RES>>() {
        override fun createWhereField(qs: QueryStructure, payload: QueryPayload) = WhereField<RUN_RES>(qs, payload, clazz)
        override fun createOrderByField(qs: QueryStructure, payload: QueryPayload) = OrderByField<RUN_RES>(qs, payload, clazz)
        override fun createColumnLimitField(qs: QueryStructure, payload: QueryPayload) = ColumnLimiterField<RUN_RES>(qs, payload, clazz)
        override fun createColumnsLimitField(qs: QueryStructure, payload: QueryPayload) = ColumnsLimiterField<RUN_RES>(qs, payload, clazz)
    }

    inner class WhereField<RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class<MAIN>
    ): Field<RUN_RES>() {
        override val fieldType = ExpressionType.WHERE

        fun <A: Any> column(alias: String, column: Col<A>) = column.toField(alias).makeKeywords()
        fun <TA: Any> column(column: Col1<TA>) = column.toField().makeKeywords()
        private fun Column.makeKeywords() = Keywords(this, queryStructure, payload, ::createWhereField)
    }

    inner class OrderByField<RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class<MAIN>
    ): Field<RUN_RES>() {
        override val fieldType = ExpressionType.ORDER_BY

        fun <A: Any> column(alias: String, column: Col<A>) = column.toField(alias).makeKeywords()
        fun <TA: Any> column(column: Col1<TA>) = column.toField().makeKeywords()
        private fun Column.makeKeywords() = KeywordsOrderBy(this, queryStructure, payload, ::createOrderByField)
    }

    inner class ColumnLimiterField<RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class<MAIN>
    ): Field<RUN_RES>() {
        override val fieldType = ExpressionType.COLUMN_LIMITER

        fun <TA: Any, V: Any> column(alias: String, column: Get<TA, V>) = column.toField(alias).queryWithColumnLimiter(column.getReturnType())
        fun <TA: Any, V: Any> column(column: Get1<TA, V>) = column.toField().queryWithColumnLimiter(column.getReturnType())
        private fun <V: Any> Column.queryWithColumnLimiter(clazz: Class<V>) = ListEx(getColumn(this, clazz))
    }

    inner class ColumnsLimiterField<RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class<MAIN>
    ): Field<RUN_RES>() {
        override val fieldType = ExpressionType.COLUMNS_LIMITER

        fun <A: Any> column(alias: String, column: Col<A>) = column.toField(alias).makeColumnsLimiter()
        fun <TA: Any> column(column: Col1<TA>) = column.toField().makeColumnsLimiter()
        private fun Column.makeColumnsLimiter() = this@ColumnsLimiterField.also {
            queryStructure.fields = queryStructure.fields + this
        }
    }

    inner class Joined  {
        fun <NEW : Any> leftJoin(entity: Class<NEW>) = On<NEW>(JoinType.LEFT_JOIN, entity)
        fun <NEW : Any> rightJoin(entity: Class<NEW>) = On<NEW>(JoinType.RIGHT_JOIN, entity)
        fun <NEW : Any> innerJoin(entity: Class<NEW>) = On<NEW>(JoinType.INNER_JOIN, entity)
        fun <NEW : Any> leftJoin(entity: Class<NEW>, alias: String) = On<Alias>(JoinType.LEFT_JOIN, entity, alias)
        fun <NEW : Any> rightJoin(entity: Class<NEW>, alias: String) = On<Alias>(JoinType.RIGHT_JOIN, entity, alias)
        fun <NEW : Any> innerJoin(entity: Class<NEW>, alias: String) = On<Alias>(JoinType.INNER_JOIN, entity, alias)

        fun where() = WhereField<List<MAIN>>(queryStructure, payload, clazz)
    }
}
