## resolver包
将`QueryStructure`等结构转换为`SQL`并执行或直接执行`SQL`

---

* [Resolver.kt](Resolver.kt) 该包最终对外暴露的类，是对`IQueryStructureResolver`的包装，其主要目的是为`IQueryStructureResolver`引入生命周期的支持。
* [IQueryStructureResolver.kt](IQueryStructureResolver.kt) 主要用于解析对象并执行或直接执行`SQL`。
* [QSR.kt](QSR.kt) 默认的`IQueryStructureResolver`模版类，往往继承该类从而实现`IQueryStructureResolver`会比直接实现`IQueryStructureResolver`更加方便些。
* [JdbcQSR.kt](JdbcQSR.kt) 继承自`QSR`, `IQueryStructureResolver`接口的`JDBC`实现。
* [ToSqlByQueryStructure.kt](ToSqlByQueryStructure.kt) 工具类，目的是将`QueryStructure`转换为`JDBC`风格的`SQL`(`SQL`语句中参数占位符为`?`)及其参数。
* [ToSqlByInsertObjects.kt](ToSqlByInsertObjects.kt) 工具类，目的是根据需要`insert`的对象以及目标数据库表信息生成对应的`SQL`语句(同样是JDBC风格的，参数占位符为`?`)
