package cn.cloudself.query.resolver

import cn.cloudself.query.config.SqlAndParams

/**
 * 工具类，目的是根据需要`insert`的对象以及目标数据库表信息生成对应的`SQL`语句(JDBC风格，参数占位符为`?`)
 */
object ToSqlByInsertObjects {
    fun toSql(objs: Collection<Any>, table: String, columns: Collection<QSR.Column>): List<SqlAndParams> {
        val sqlAndParamsList = mutableListOf<SqlAndParams>()
        val hasId = Array(objs.size) { false }
        val paramsArr = objs.mapIndexed { i, obj ->
            columns.map { col ->
                val value = col.getter(obj)
                if (col.isId && value != null) {
                    hasId[i] = true
                }
                value
            }.toTypedArray()
        }
        // 单条插入时，自动去掉null字段
        val uniqueInsert = paramsArr.size == 1

        val sqlBuilder = StringBuilder("INSERT INTO `")
        sqlBuilder.append(table, "` (")
        var firstAppend = false
        for ((i, col) in columns.withIndex()) {
            if (uniqueInsert && paramsArr[0][i] == null) {
                continue
            }
            if (firstAppend) {
                sqlBuilder.append(", ")
            } else {
                firstAppend = true
            }
            sqlBuilder.append('`', col.column, '`')
        }
        sqlBuilder.append(") VALUES ")
        val sqlPrefix = sqlBuilder.toString()

        var curParams = mutableListOf<Any?>()
        var firstRow = true
        var firstRowIndex = 0
        var batchMode = false
        var lastHasId = false
        for ((i, params) in paramsArr.withIndex()) {
            if ((sqlBuilder.length > 1000 * 500) || (i != 0 && i % 1000 == 0) || hasId[i] || lastHasId) { // ~0.5M if all ascii char
                batchMode = true
                sqlAndParamsList.add(SqlAndParams("/*BATCH MODE ${if(i > 999) i - 999 else i} to ${i}*/ $sqlBuilder", curParams.toTypedArray()))
                sqlBuilder.clear()
                sqlBuilder.append(sqlPrefix)
                curParams = mutableListOf()
                firstRow = true
                firstRowIndex = i
            }
            lastHasId = hasId[i]
            if (uniqueInsert) {
                for (param in params) {
                    if (param != null) {
                        curParams.add(param)
                    }
                }
            } else {
                curParams.addAll(params)
            }
            sqlBuilder.append(if (firstRow) { firstRow = false; "(" } else ", (")
            var firstCol = true
            for (j in columns.indices) {
                if (uniqueInsert && params[j] == null) {
                    continue
                }
                sqlBuilder.append(if (firstCol) { firstCol = false; "?" } else ", ?")
            }
            sqlBuilder.append(')')
        }

        if (!firstRow) {
            val sql = if (batchMode) "/*BATCH MODE ${firstRowIndex + 1} to ${paramsArr.size}*/ $sqlBuilder" else sqlBuilder.toString()
            val params = curParams.toTypedArray()
            sqlAndParamsList.add(SqlAndParams(sql, params))
        }

        return sqlAndParamsList
    }
}