package cn.cloudself.query.plus

import cn.cloudself.query.*

class QueryProPlus<MAIN: Any, T: Any> constructor(
    private val queryStructure: QueryStructure,
    private val payload: QueryPayload,
    private val clazz: Class<MAIN>,
    alias: String? = null
) {

    init {
        if (alias != null) {
            queryStructure.from.alias = alias
        }
    }

    fun <NEW: Any> leftJoin (entity: Class<NEW>) = Plus2Table<MAIN, T, NEW>(queryStructure, payload, clazz).On(JoinType.LEFT_JOIN, entity)
    fun <NEW: Any> rightJoin(entity: Class<NEW>) = Plus2Table<MAIN, T, NEW>(queryStructure, payload, clazz).On(JoinType.RIGHT_JOIN, entity)
    fun <NEW: Any> innerJoin(entity: Class<NEW>) = Plus2Table<MAIN, T, NEW>(queryStructure, payload, clazz).On(JoinType.INNER_JOIN, entity)
    fun <NEW: Any> leftJoin (entity: Class<NEW>, alias: String) = Plus2Table<MAIN, T, Alias>(queryStructure, payload, clazz).On(JoinType.LEFT_JOIN, entity, alias)
    fun <NEW: Any> rightJoin(entity: Class<NEW>, alias: String) = Plus2Table<MAIN, T, Alias>(queryStructure, payload, clazz).On(JoinType.RIGHT_JOIN, entity, alias)
    fun <NEW: Any> innerJoin(entity: Class<NEW>, alias: String) = Plus2Table<MAIN, T, Alias>(queryStructure, payload, clazz).On(JoinType.INNER_JOIN, entity, alias)
}
