package cn.cloudself.query.plus

import cn.cloudself.query.*

class Plus7Table<MAIN: Any, T1: Any, T2: Any, T3: Any, T4: Any, T5: Any, T6: Any, T7: Any> constructor(
    private val queryStructure: QueryStructure,
    private val payload: QueryPayload,
    private val clazz: Class<MAIN>,
) {
    inner class On constructor(
        private val joinType: JoinType,
        private val newClazz: Class<*>,
        private val alias: String? = null,
    ) {
        private fun on(left: Column, right: Column): PlusManyTable<MAIN>.Joined {
            val table = newClazz.toTable()
            val joinerOns = listOf(FromJoinerOn(left, right))
            queryStructure.from.joins.add(FromJoiner(joinType, table, joinerOns, alias))
            return PlusManyTable(queryStructure, payload, clazz).Joined()
        }

        fun on(t1: Col1<T1>, new: ColNew<T7>) = on(t1.toField(), new.toField())
        fun on(t2: Col2<T2>, new: ColNew<T7>) = on(t2.toField(), new.toField())
        fun on(t3: Col3<T3>, new: ColNew<T7>) = on(t3.toField(), new.toField())
        fun on(t4: Col4<T4>, new: ColNew<T7>) = on(t4.toField(), new.toField())
        fun on(t5: Col5<T5>, new: ColNew<T7>) = on(t5.toField(), new.toField())
        fun on(t6: Col6<T6>, new: ColNew<T7>) = on(t6.toField(), new.toField())
        fun on(new: ColNew<T7>, t1: Col1<T1>) = on(t1, new)
        fun on(new: ColNew<T7>, t2: Col2<T2>) = on(t2, new)
        fun on(new: ColNew<T7>, t3: Col3<T3>) = on(t3, new)
        fun on(new: ColNew<T7>, t4: Col4<T4>) = on(t4, new)

        fun <TN: Any> on(table1column: Col1<T1>, tableNewAlias: String, tableNewColumn: Col<TN>) = on(table1column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(table2column: Col2<T2>, tableNewAlias: String, tableNewColumn: Col<TN>) = on(table2column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(table3column: Col3<T3>, tableNewAlias: String, tableNewColumn: Col<TN>) = on(table3column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(table4column: Col4<T4>, tableNewAlias: String, tableNewColumn: Col<TN>) = on(table4column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(table5column: Col5<T5>, tableNewAlias: String, tableNewColumn: Col<TN>) = on(table5column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(table6column: Col6<T6>, tableNewAlias: String, tableNewColumn: Col<TN>) = on(table6column.toField(), tableNewColumn.toField(tableNewAlias))

        fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Col<TN>, table1column: Col1<T1>) = on(table1column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Col<TN>, table2column: Col2<T2>) = on(table2column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Col<TN>, table3column: Col3<T3>) = on(table3column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Col<TN>, table4column: Col4<T4>) = on(table4column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Col<TN>, table5column: Col5<T5>) = on(table5column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Col<TN>, table6column: Col6<T6>) = on(table6column.toField(), tableNewColumn.toField(tableNewAlias))

        fun <TA: Any> on(table1alias: String, table1column: Col1<TA>, tableNewColumn: Col<T7>) = on(table1column.toField(table1alias), tableNewColumn.toField())
        fun <TA: Any> on(tableNewColumn: Col<T7>, table1alias: String, table1column: Col1<TA>) = on(table1column.toField(table1alias), tableNewColumn.toField())
        fun <TA: Any, TN: Any> on(table1alias: String, table1column: Col1<TA>, table2alias: String, table2column: Col2<TN>) = on(table1column.toField(table1alias), table2column.toField(table2alias))
    }
}
