package cn.cloudself.query.plus

import cn.cloudself.query.*
import cn.cloudself.query.util.ListEx

class Plus5Table<MAIN: Any, T1: Any, T2: Any, T3: Any, T4: Any, T5: Any> constructor(
    private val queryStructure: QueryStructure,
    private val payload: QueryPayload,
    private val clazz: Class<MAIN>,
) {
    inner class On constructor(
        private val joinType: JoinType,
        private val newClazz: Class<*>,
        private val alias: String? = null,
    ) {
        private fun <T1: Any, T2: Any, T3: Any, T4: Any, T5: Any> on(left: Column, right: Column): Plus5Table<MAIN, T1, T2, T3, T4, T5>.Joined {
            val table = newClazz.toTable()
            val joinerOns = listOf(FromJoinerOn(left, right))
            queryStructure.from.joins.add(FromJoiner(joinType, table, joinerOns, alias))
            return Plus5Table<MAIN, T1, T2, T3, T4, T5>(queryStructure, payload, clazz).Joined()
        }

        fun on(t1: Col1<T1>, new: ColNew<T5>) = on<T1, T2, T3, T4, T5>(t1.toField(), new.toField())
        fun on(t2: Col2<T2>, new: ColNew<T5>) = on<T1, T2, T3, T4, T5>(t2.toField(), new.toField())
        fun on(t3: Col3<T3>, new: ColNew<T5>) = on<T1, T2, T3, T4, T5>(t3.toField(), new.toField())
        fun on(t4: Col4<T4>, new: ColNew<T5>) = on<T1, T2, T3, T4, T5>(t4.toField(), new.toField())
        fun on(new: ColNew<T5>, t1: Col1<T1>) = on(t1, new)
        fun on(new: ColNew<T5>, t2: Col2<T2>) = on(t2, new)
        fun on(new: ColNew<T5>, t3: Col3<T3>) = on(t3, new)
        fun on(new: ColNew<T5>, t4: Col4<T4>) = on(t4, new)

        fun <TN: Any> on(table1column: Col1<T1>, tableNewAlias: String, tableNewColumn: Col<TN>) = on<T1, T2, T3, T4, Alias>(table1column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(table2column: Col2<T2>, tableNewAlias: String, tableNewColumn: Col<TN>) = on<T1, T2, T3, T4, Alias>(table2column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(table3column: Col3<T3>, tableNewAlias: String, tableNewColumn: Col<TN>) = on<T1, T2, T3, T4, Alias>(table3column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(table4column: Col4<T4>, tableNewAlias: String, tableNewColumn: Col<TN>) = on<T1, T2, T3, T4, Alias>(table4column.toField(), tableNewColumn.toField(tableNewAlias))

        fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Col<TN>, table1column: Col1<T1>) = on<T1, T2, T3, T4, Alias>(table1column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Col<TN>, table2column: Col2<T2>) = on<T1, T2, T3, T4, Alias>(table2column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Col<TN>, table3column: Col3<T3>) = on<T1, T2, T3, T4, Alias>(table3column.toField(), tableNewColumn.toField(tableNewAlias))
        fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Col<TN>, table4column: Col4<T4>) = on<T1, T2, T3, T4, Alias>(table4column.toField(), tableNewColumn.toField(tableNewAlias))

        fun <TA: Any> on(table1alias: String, table1column: Col1<TA>, table3column: Col<T5>) = on<T1, T2, T3, T4, T5>(table1column.toField(table1alias), table3column.toField())
        fun <TA: Any> on(table3column: Col<T5>, table1alias: String, table1column: Col1<TA>) = on<T1, T2, T3, T4, T5>(table1column.toField(table1alias), table3column.toField())
        fun <TA: Any, TN: Any> on(table1alias: String, table1column: Col1<TA>, table2alias: String, table2column: Col2<TN>) = on<T1, T2, T3, T4, Alias>(table1column.toField(table1alias), table2column.toField(table2alias))
    }

    abstract inner class Field<RUN_RES>: QueryField<MAIN, RUN_RES, WhereField<RUN_RES>, OrderByField<RUN_RES>, ColumnLimiterField<RUN_RES>, ColumnsLimiterField<RUN_RES>>() {
        override fun createWhereField(qs: QueryStructure, payload: QueryPayload) = WhereField<RUN_RES>(qs, payload, clazz)
        override fun createOrderByField(qs: QueryStructure, payload: QueryPayload) = OrderByField<RUN_RES>(qs, payload, clazz)
        override fun createColumnLimitField(qs: QueryStructure, payload: QueryPayload) = ColumnLimiterField<RUN_RES>(qs, payload, clazz)
        override fun createColumnsLimitField(qs: QueryStructure, payload: QueryPayload) = ColumnsLimiterField<RUN_RES>(qs, payload, clazz)
    }

    inner class WhereField<RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class<MAIN>
    ): Field<RUN_RES>() {
        override val fieldType = QueryFieldType.WHERE_FIELD

        fun <A: Any> column(alias: String, column: Col<A>) = column.toField(alias).makeKeywords()
        fun column(column: Col1<T1>) = column.toField().makeKeywords()
        fun column(column: Col2<T2>) = column.toField().makeKeywords()
        fun column(column: Col3<T3>) = column.toField().makeKeywords()
        fun column(column: Col4<T4>) = column.toField().makeKeywords()
        fun column(column: Col5<T5>) = column.toField().makeKeywords()
        private fun Column.makeKeywords() = QueryKeywords(this, queryStructure, payload, ::createWhereField)
    }

    inner class OrderByField<RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class<MAIN>
    ): Field<RUN_RES>() {
        override val fieldType = QueryFieldType.ORDER_BY_FIELD

        fun <A: Any> column(alias: String, column: Col<A>) = column.toField(alias).makeKeywords()
        fun column(column: Col1<T1>) = column.toField().makeKeywords()
        fun column(column: Col2<T2>) = column.toField().makeKeywords()
        fun column(column: Col3<T3>) = column.toField().makeKeywords()
        fun column(column: Col4<T4>) = column.toField().makeKeywords()
        fun column(column: Col5<T5>) = column.toField().makeKeywords()
        private fun Column.makeKeywords() = QueryOrderByKeywords(this, queryStructure, payload, ::createOrderByField)
    }

    inner class ColumnLimiterField<RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class<MAIN>
    ): Field<RUN_RES>() {
        override val fieldType = QueryFieldType.OTHER_FIELD

        fun <TA: Any, V: Any> column(alias: String, column: Get<TA, V>) = column.toField(alias).queryWithColumnLimiter(column.getReturnType())
        fun <V: Any> column(column: Get1<T1, V>) = column.toField().queryWithColumnLimiter(column.getReturnType())
        fun <V: Any> column(column: Get2<T2, V>) = column.toField().queryWithColumnLimiter(column.getReturnType())
        fun <V: Any> column(column: Get3<T3, V>) = column.toField().queryWithColumnLimiter(column.getReturnType())
        fun <V: Any> column(column: Get4<T4, V>) = column.toField().queryWithColumnLimiter(column.getReturnType())
        fun <V: Any> column(column: Get5<T5, V>) = column.toField().queryWithColumnLimiter(column.getReturnType())
        private fun <V: Any> Column.queryWithColumnLimiter(clazz: Class<V>) = ListEx(getColumn(this, clazz))
    }

    inner class ColumnsLimiterField<RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class<MAIN>
    ): Field<RUN_RES>() {
        override val fieldType = QueryFieldType.OTHER_FIELD

        fun <A: Any> column(alias: String, column: Col<A>) = column.toField(alias).makeColumnsLimiter()
        fun column(column: Col1<T1>) = column.toField().makeColumnsLimiter()
        fun column(column: Col2<T2>) = column.toField().makeColumnsLimiter()
        fun column(column: Col3<T3>) = column.toField().makeColumnsLimiter()
        fun column(column: Col4<T4>) = column.toField().makeColumnsLimiter()
        fun column(column: Col5<T5>) = column.toField().makeColumnsLimiter()
        private fun Column.makeColumnsLimiter() = this.also {
            queryStructure.fields = queryStructure.fields + this
        }
    }

    inner class Joined {
        fun <NEW: Any> leftJoin (entity: Class<NEW>) = Plus6Table<MAIN, T1, T2, T3, T4, T5, NEW>(queryStructure, payload, clazz).On(JoinType.LEFT_JOIN, entity)
        fun <NEW: Any> rightJoin(entity: Class<NEW>) = Plus6Table<MAIN, T1, T2, T3, T4, T5, NEW>(queryStructure, payload, clazz).On(JoinType.RIGHT_JOIN, entity)
        fun <NEW: Any> innerJoin(entity: Class<NEW>) = Plus6Table<MAIN, T1, T2, T3, T4, T5, NEW>(queryStructure, payload, clazz).On(JoinType.INNER_JOIN, entity)
        fun <NEW: Any> leftJoin (entity: Class<NEW>, alias: String) = Plus6Table<MAIN, T1, T2, T3, T4, T5, Alias>(queryStructure, payload, clazz).On(JoinType.LEFT_JOIN, entity, alias)
        fun <NEW: Any> rightJoin(entity: Class<NEW>, alias: String) = Plus6Table<MAIN, T1, T2, T3, T4, T5, Alias>(queryStructure, payload, clazz).On(JoinType.RIGHT_JOIN, entity, alias)
        fun <NEW: Any> innerJoin(entity: Class<NEW>, alias: String) = Plus6Table<MAIN, T1, T2, T3, T4, T5, Alias>(queryStructure, payload, clazz).On(JoinType.INNER_JOIN, entity, alias)

        fun where() = WhereField<List<MAIN>>(queryStructure, payload, clazz)
    }
}
